/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.operator.jcajce;

import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.operator.GenericKey;
import cn.tca.TopBasicCrypto.operator.OperatorException;
import cn.tca.TopBasicCrypto.operator.SymmetricKeyUnwrapper;
import cn.topca.core.ext.bc.jcajce.DefaultJcaJceHelper;
import cn.topca.core.ext.bc.jcajce.NamedJcaJceHelper;
import cn.topca.core.ext.bc.jcajce.ProviderJcaJceHelper;
import cn.topca.core.ext.bc.operator.jcajce.OperatorHelper;
import cn.topca.core.ext.bc.util.OIDUtils;
import cn.topca.crypto.Cipher;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.SecretKey;

public class JceSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecretKey secretKey;

    public JceSymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, SecretKey secretKey) {
        super(algorithmIdentifier);
        this.secretKey = secretKey;
    }

    public JceSymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceSymmetricKeyUnwrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        try {
            Cipher keyCipher = this.helper.createSymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
            keyCipher.init(4, this.secretKey);
            return new GenericKey((Object)keyCipher.unwrap(encryptedKey, OIDUtils.getName(encryptedKeyAlgorithm.getAlgorithm().getId()), 3));
        }
        catch (InvalidKeyException e) {
            throw new OperatorException("key invalid in message.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OperatorException("can't find algorithm.", (Throwable)e);
        }
    }
}

