/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.pkcs;

import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.operator.ContentSigner;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.pkcs.PKCS10CertificationRequestBuilder;
import cn.tca.TopBasicCrypto.pkcs.PKCS10CertificationRequestHolder;
import cn.topca.core.ext.bc.operator.jcajce.JcaContentSignerBuilder;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;

public class PKCS10OperatorUtils {
    public static String genCSR(String subject, String digestAlg, KeyPair keyPair, String provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, OperatorCreationException, IOException {
        String keyAlg = keyPair.getPrivate().getAlgorithm();
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(new X500Name(subject), SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
        JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder(digestAlg + "with" + keyAlg);
        if (provider != null) {
            jcaContentSignerBuilder.setProvider(provider);
        }
        ContentSigner contentSigner = jcaContentSignerBuilder.build(keyPair.getPrivate());
        PKCS10CertificationRequestHolder pkcs10CertificationRequestHolder = builder.build(contentSigner);
        return Base64.encodeBase64String((byte[])pkcs10CertificationRequestHolder.getEncoded());
    }

    public static String genCSR(String subject, String digestAlg, KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, OperatorCreationException, IOException {
        String providerName = null;
        if (provider != null) {
            providerName = provider.getName();
        }
        return PKCS10OperatorUtils.genCSR(subject, digestAlg, keyPair, providerName);
    }
}

