/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.util;

import cn.tca.TopBasicCrypto.asn1.nist.NISTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.oiw.OIWObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.topca.core.ext.bc.asn1.gm.GMObjectIdentifiers;
import cn.topca.security.JCAJCEUtils;
import java.util.HashMap;
import java.util.Map;

public class OIDUtils {
    protected static Map oidMap = new HashMap();
    protected static Map nameMap = new HashMap();

    private OIDUtils() {
    }

    private static void addSymmetricKeyName() {
        nameMap.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), "DESede");
        nameMap.put(GMObjectIdentifiers.sm4.getId(), "SM4");
        nameMap.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), "AES");
    }

    private static void addDigestOid() {
        oidMap.put("SHA", OIWObjectIdentifiers.idSHA1);
        oidMap.put("SHA1", OIWObjectIdentifiers.idSHA1);
        oidMap.put("SHA224", NISTObjectIdentifiers.id_sha224);
        oidMap.put("SHA256", NISTObjectIdentifiers.id_sha256);
        oidMap.put("SHA384", NISTObjectIdentifiers.id_sha384);
        oidMap.put("SHA512", NISTObjectIdentifiers.id_sha512);
        oidMap.put("SM3", GMObjectIdentifiers.sm3.getId());
    }

    private static void addSymmetricKeyOid() {
        oidMap.put("DESede", PKCSObjectIdentifiers.des_EDE3_CBC.getId());
        oidMap.put("TripleDES", PKCSObjectIdentifiers.des_EDE3_CBC.getId());
        oidMap.put("SM4", GMObjectIdentifiers.sm4.getId());
    }

    public static String getOID(String name) {
        String oid = (String)oidMap.get(name);
        if (oid != null) {
            return oid;
        }
        return name;
    }

    public static String getName(String oid) {
        String name;
        if (JCAJCEUtils.isValidIdentifier(oid) && (name = (String)nameMap.get(oid)) != null) {
            return name;
        }
        return oid;
    }

    static {
        OIDUtils.addSymmetricKeyOid();
        OIDUtils.addDigestOid();
        OIDUtils.addSymmetricKeyName();
    }
}

