/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.util;

import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.util.Selector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;

public class X509CertificateHolderSelector
extends X509CertSelector
implements Selector {
    public boolean match(X509CertificateHolder cert) {
        return this.match((Object)cert);
    }

    public boolean match(Object obj) {
        if (obj instanceof X509CertificateHolder) {
            try {
                X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)obj;
                Provider provider = Security.getProvider("TopSM");
                CertificateFactory cf = provider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
                ByteArrayInputStream is1 = new ByteArrayInputStream(x509CertificateHolder.toASN1Structure().getEncoded());
                X509Certificate theCert = (X509Certificate)cf.generateCertificate(is1);
                ((InputStream)is1).close();
                return super.match(theCert);
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Object clone() {
        X509CertificateHolderSelector selector = (X509CertificateHolderSelector)super.clone();
        return selector;
    }
}

