/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.x509;

import cn.tca.TopBasicCrypto.asn1.ASN1Choice;
import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERPrintableString;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.tca.TopBasicCrypto.asn1.DERUTF8String;

public class IdentityCode
extends ASN1Encodable
implements ASN1Choice {
    private Type type;
    private String idCode;

    public IdentityCode(Type type, String idCode) {
        this.type = type;
        this.idCode = idCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append((Object)this.type);
        buf.append(": ");
        buf.append(this.idCode);
        return buf.toString();
    }

    public DERObject toASN1Object() {
        DERUTF8String obj;
        switch (this.type) {
            case militaryOfficerCardNumber: {
                obj = new DERUTF8String(this.idCode);
                break;
            }
            case passportNumber: 
            case residenterCardNumber: {
                obj = new DERPrintableString(this.idCode);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported IdentityCode type.");
            }
        }
        return new DERTaggedObject(false, this.type.ordinal(), (DEREncodable)obj);
    }

    public static IdentityCode getInstance(Object obj) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        residenterCardNumber,
        militaryOfficerCardNumber,
        passportNumber;

    }
}

