/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.crypto;

import cn.topca.crypto.JCEAgentUtils;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cipher {
    private static final Logger log = LoggerFactory.getLogger(Cipher.class);
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int PUBLIC_KEY = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int SECRET_KEY = 3;
    private final Provider provider;
    private final CipherSpi spi;
    private final String transformation;
    private final javax.crypto.Cipher jceService;
    private static final String KEY_USAGE_EXTENSION_OID = "2.5.29.15";

    public Cipher(javax.crypto.Cipher cipher) {
        log.debug("#compatibility");
        log.debug("use JCE Cipher for " + cipher.getAlgorithm());
        this.jceService = cipher;
        this.spi = null;
        this.provider = cipher.getProvider();
        this.transformation = cipher.getAlgorithm();
    }

    protected Cipher(CipherSpi spi, Provider provider, String transformation) {
        this.jceService = null;
        this.spi = spi;
        this.provider = provider;
        this.transformation = transformation;
    }

    public static Cipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(transformation);
            return new Cipher(cipher);
        }
        catch (Exception e) {
            Provider[] providers = Security.getProviders("Cipher." + transformation);
            if (providers != null && providers.length > 0) {
                return Cipher.getInstance(transformation, providers[0]);
            }
            throw new NoSuchAlgorithmException(transformation + " Cipher not available");
        }
    }

    public static Cipher getInstance(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(transformation, provider);
            return new Cipher(cipher);
        }
        catch (Exception e) {
            CipherSpi spi = null;
            Provider.Service service = provider.getService("Cipher", transformation);
            if (service != null) {
                spi = (CipherSpi)service.newInstance(null);
            }
            if (spi != null) {
                return new Cipher(spi, provider, service.getAlgorithm());
            }
            throw new NoSuchAlgorithmException("no such " + transformation + " for " + provider.getName());
        }
    }

    public static Cipher getInstance(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return Cipher.getInstance(transformation, p);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        if (this.jceService != null) {
            return this.jceService.getBlockSize();
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineGetBlockSize", null, new Object[0]);
    }

    public final int getOutputSize(int inputLen) {
        if (this.jceService != null) {
            return this.jceService.getOutputSize(inputLen);
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineGetOutputSize", new Class[]{Integer.TYPE}, inputLen);
    }

    public final byte[] getIV() {
        if (this.jceService != null) {
            return this.jceService.getIV();
        }
        return (byte[])JCEAgentUtils.invokeSpi(this.spi, "engineGetIV", null, new Object[0]);
    }

    public final AlgorithmParameters getParameters() {
        if (this.jceService != null) {
            return this.jceService.getParameters();
        }
        return (AlgorithmParameters)JCEAgentUtils.invokeSpi(this.spi, "engineGetParameters", null, new Object[0]);
    }

    public final void init(int opmode, Key key) throws InvalidKeyException {
        if (this.jceService != null) {
            this.jceService.init(opmode, key);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{Integer.TYPE, Key.class, SecureRandom.class}, opmode, key, new SecureRandom());
    }

    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (this.jceService != null) {
            this.jceService.init(opmode, key, random);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{Integer.TYPE, Key.class, SecureRandom.class}, opmode, key, random);
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.jceService != null) {
            this.jceService.init(opmode, key, params);
            return;
        }
        this.init(opmode, key, params, null);
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.jceService != null) {
            this.jceService.init(opmode, key, params, random);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{Integer.TYPE, Key.class, AlgorithmParameterSpec.class, SecureRandom.class}, opmode, key, params, random);
    }

    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.jceService != null) {
            this.jceService.init(opmode, key, params);
            return;
        }
        this.init(opmode, key, params, null);
    }

    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.jceService != null) {
            this.jceService.init(opmode, key, params, random);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{Integer.TYPE, Key.class, AlgorithmParameters.class, SecureRandom.class}, opmode, key, params, random);
    }

    public final void init(int opmode, Certificate certificate) throws InvalidKeyException {
        if (this.jceService != null) {
            this.jceService.init(opmode, certificate);
            return;
        }
        this.init(opmode, certificate, null);
    }

    public final void init(int opmode, Certificate certificate, SecureRandom random) throws InvalidKeyException {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (this.jceService != null) {
            this.jceService.init(opmode, certificate, random);
            return;
        }
        if (certificate instanceof X509Certificate && (critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !critSet.isEmpty() && critSet.contains(KEY_USAGE_EXTENSION_OID) && (keyUsageInfo = cert.getKeyUsage()) != null && (opmode == 1 && keyUsageInfo.length > 3 && !keyUsageInfo[3] || opmode == 3 && keyUsageInfo.length > 2 && !keyUsageInfo[2])) {
            throw new InvalidKeyException("Wrong key usage");
        }
        PublicKey publicKey = certificate == null ? null : certificate.getPublicKey();
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{Integer.TYPE, Key.class, SecureRandom.class}, opmode, publicKey, random);
    }

    public final byte[] update(byte[] input) {
        if (this.jceService != null) {
            return this.jceService.update(input);
        }
        if (input == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        if (input.length == 0) {
            return null;
        }
        return (byte[])JCEAgentUtils.invokeSpi(this.spi, "engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, 0, input.length);
    }

    public final byte[] update(byte[] input, int inputOffset, int inputLen) {
        if (this.jceService != null) {
            return this.jceService.update(input, inputOffset, inputLen);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return null;
        }
        return (byte[])JCEAgentUtils.invokeSpi(this.spi, "engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, inputOffset, inputLen);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException {
        if (this.jceService != null) {
            return this.jceService.update(input, inputOffset, inputLen, output);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, input, inputOffset, inputLen, output, 0);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0 || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, input, inputOffset, inputLen, output, outputOffset);
    }

    public final int update(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        if (this.jceService != null) {
            return this.jceService.update(input, output);
        }
        if (input == null || output == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (input == output) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (output.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineUpdate", new Class[]{ByteBuffer.class, ByteBuffer.class}, input, output);
    }

    public final byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        if (this.jceService != null) {
            return this.jceService.doFinal();
        }
        return (byte[])JCEAgentUtils.invokeSpi(this.spi, "engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new byte[0], 0, 0);
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (this.jceService != null) {
            return this.jceService.doFinal(output, outputOffset);
        }
        if (output == null || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, null, 0, 0, output, outputOffset);
    }

    public final byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        if (this.jceService != null) {
            return this.jceService.doFinal(input);
        }
        return (byte[])JCEAgentUtils.invokeSpi(this.spi, "engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, 0, input.length);
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this.jceService != null) {
            return this.jceService.doFinal(input, inputOffset, inputLen);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return (byte[])JCEAgentUtils.invokeSpi(this.spi, "engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, inputOffset, inputLen);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.jceService != null) {
            return this.jceService.doFinal(input, inputOffset, inputLen, output);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, input, inputOffset, inputLen, output, 0);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.jceService != null) {
            return this.jceService.doFinal(input, inputOffset, inputLen, output, outputOffset);
        }
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0 || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineDoFinal", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE}, input, inputOffset, inputLen, output, outputOffset);
    }

    public final int doFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.jceService != null) {
            return this.jceService.doFinal(input, output);
        }
        if (input == null || output == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (input == output) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (output.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineDoFinal", new Class[]{ByteBuffer.class, ByteBuffer.class}, input, output);
    }

    public final byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.jceService != null) {
            return this.jceService.wrap(key);
        }
        return (byte[])JCEAgentUtils.invokeSpi(this.spi, "engineWrap", new Class[]{Key.class}, key);
    }

    public final Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.jceService != null) {
            return this.jceService.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
        }
        if (wrappedKeyType != 3 && wrappedKeyType != 2 && wrappedKeyType != 1) {
            throw new InvalidParameterException("Invalid key type");
        }
        return (Key)JCEAgentUtils.invokeSpi(this.spi, "engineUnwrap", new Class[]{byte[].class, String.class, Integer.TYPE}, wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public javax.crypto.Cipher getCipher() {
        return this.jceService;
    }
}

