/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.crypto;

import cn.topca.crypto.JCEAgentUtils;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mac
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(Mac.class);
    private final Provider provider;
    private MacSpi spi;
    private final String algorithm;
    private final javax.crypto.Mac jceService;
    private boolean initialized = false;

    protected Mac(MacSpi macSpi, Provider provider, String algorithm) {
        this.spi = macSpi;
        this.jceService = null;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public Mac(javax.crypto.Mac mac) {
        this.spi = null;
        this.jceService = mac;
        this.provider = mac.getProvider();
        this.algorithm = mac.getAlgorithm();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String algorithm) throws NoSuchAlgorithmException {
        try {
            javax.crypto.Mac mac = javax.crypto.Mac.getInstance(algorithm);
            return new Mac(mac);
        }
        catch (Exception e) {
            Provider[] providers = Security.getProviders("Mac." + algorithm);
            if (providers != null && providers.length > 0) {
                return Mac.getInstance(algorithm, providers[0]);
            }
            throw new NoSuchAlgorithmException(algorithm + " Mac not available");
        }
    }

    public static final Mac getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return Mac.getInstance(algorithm, p);
    }

    public static final Mac getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            javax.crypto.Mac mac = javax.crypto.Mac.getInstance(algorithm);
            return new Mac(mac);
        }
        catch (Exception e) {
            MacSpi spi = null;
            Provider.Service service = provider.getService("Mac", algorithm);
            if (service != null) {
                spi = (MacSpi)service.newInstance(null);
            }
            if (spi != null) {
                return new Mac(spi, provider, service.getAlgorithm());
            }
            throw new NoSuchAlgorithmException("no such " + algorithm + " for " + provider.getName());
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final int getMacLength() {
        if (this.jceService != null) {
            return this.jceService.getMacLength();
        }
        return (Integer)JCEAgentUtils.invokeSpi(this.spi, "engineGetMacLength", null, new Object[0]);
    }

    public final void init(Key key) throws InvalidKeyException {
        if (this.jceService != null) {
            this.jceService.init(key);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{Key.class}, key, null);
        this.initialized = true;
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.jceService != null) {
            this.jceService.init(key, params);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{Key.class, AlgorithmParameterSpec.class}, key, params);
        this.initialized = true;
    }

    public final void update(byte input) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (this.jceService != null) {
            this.jceService.update(input);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineUpdate", new Class[]{Byte.TYPE}, input);
    }

    public final void update(byte[] input) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (input != null) {
            if (this.jceService != null) {
                this.jceService.update(input);
                return;
            }
            JCEAgentUtils.invokeSpi(this.spi, "engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, 0, input.length);
        }
    }

    public final void update(byte[] input, int offset, int len) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (input != null) {
            if (offset < 0 || len > input.length - offset || len < 0) {
                throw new IllegalArgumentException("Bad arguments");
            }
            if (this.jceService != null) {
                this.jceService.update(input, offset, len);
                return;
            }
            JCEAgentUtils.invokeSpi(this.spi, "engineUpdate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, input, offset, len);
        }
    }

    public final void update(ByteBuffer input) {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("Buffer must not be null");
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineUpdate", new Class[]{ByteBuffer.class}, input);
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        byte[] mac = (byte[])JCEAgentUtils.invokeSpi(this.spi, "engineDoFinal", null, new Object[0]);
        JCEAgentUtils.invokeSpi(this.spi, "engineReset", null, new Object[0]);
        return mac;
    }

    public final void doFinal(byte[] output, int outOffset) throws ShortBufferException, IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        int macLen = this.getMacLength();
        if (output == null || output.length - outOffset < macLen) {
            throw new ShortBufferException("Cannot store MAC in output buffer");
        }
        byte[] mac = this.doFinal();
        System.arraycopy(mac, 0, output, outOffset, macLen);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.update(input);
        return this.doFinal();
    }

    public final void reset() {
        JCEAgentUtils.invokeSpi(this.spi, "engineReset", null, new Object[0]);
    }

    public final Object clone() throws CloneNotSupportedException {
        Mac that = (Mac)super.clone();
        that.spi = (MacSpi)this.spi.clone();
        return that;
    }
}

