/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.util;

import cn.topca.util.CodecUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class ConvUtil {
    private static CertificateFactory cf = null;

    private ConvUtil() {
    }

    public static X509Certificate convB642Cert(String b64) throws CertificateException {
        b64 = b64.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", "").replaceAll("\r", "").replaceAll("\n", "");
        return ConvUtil.convBin2Cert(CodecUtil.decB64(b64));
    }

    public static X509Certificate convBin2Cert(byte[] bin) throws CertificateException {
        if (cf == null) {
            cf = CertificateFactory.getInstance("X.509");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bin);
        return (X509Certificate)cf.generateCertificate(bis);
    }

    public static X509CRL convB642CRL(String b64) throws CertificateException, CRLException {
        b64 = b64.replaceAll("-----BEGIN CRL-----", "").replaceAll("-----BEGIN X509 CRL-----", "").replaceAll("-----END CRL-----", "").replaceAll("-----END X509 CRL-----", "").replaceAll("\r", "").replaceAll("\n", "");
        return ConvUtil.convBin2CRL(CodecUtil.decB64(b64));
    }

    public static X509CRL convBin2CRL(byte[] bin) throws CertificateException, CRLException {
        if (cf == null) {
            cf = CertificateFactory.getInstance("X.509");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bin);
        return (X509CRL)cf.generateCRL(bis);
    }
}

