/*
 * Decompiled with CFR 0.152.
 */
package com.huaban.analysis.jieba.viterbi;

import com.huaban.analysis.jieba.CharacterUtil;
import com.huaban.analysis.jieba.Node;
import com.huaban.analysis.jieba.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;

public class FinalSeg {
    private static FinalSeg singleInstance;
    private static final String PROB_EMIT = "/prob_emit.txt";
    private static char[] states;
    private static Map<Character, Map<Character, Double>> emit;
    private static Map<Character, Double> start;
    private static Map<Character, Map<Character, Double>> trans;
    private static Map<Character, char[]> prevStatus;
    private static Double MIN_FLOAT;

    static {
        states = new char[]{'B', 'M', 'E', 'S'};
        MIN_FLOAT = -3.14E100;
    }

    private FinalSeg() {
    }

    public static synchronized FinalSeg getInstance() {
        if (singleInstance == null) {
            singleInstance = new FinalSeg();
            singleInstance.loadModel();
        }
        return singleInstance;
    }

    private void loadModel() {
        long s;
        block16: {
            s = System.currentTimeMillis();
            prevStatus = new HashMap<Character, char[]>();
            prevStatus.put(Character.valueOf('B'), new char[]{'E', 'S'});
            prevStatus.put(Character.valueOf('M'), new char[]{'M', 'B'});
            prevStatus.put(Character.valueOf('S'), new char[]{'S', 'E'});
            prevStatus.put(Character.valueOf('E'), new char[]{'B', 'M'});
            start = new HashMap<Character, Double>();
            start.put(Character.valueOf('B'), -0.26268660809250016);
            start.put(Character.valueOf('E'), -3.14E100);
            start.put(Character.valueOf('M'), -3.14E100);
            start.put(Character.valueOf('S'), -1.4652633398537678);
            trans = new HashMap<Character, Map<Character, Double>>();
            HashMap<Character, Double> transB = new HashMap<Character, Double>();
            transB.put(Character.valueOf('E'), -0.51082562376599);
            transB.put(Character.valueOf('M'), -0.916290731874155);
            trans.put(Character.valueOf('B'), transB);
            HashMap<Character, Double> transE = new HashMap<Character, Double>();
            transE.put(Character.valueOf('B'), -0.5897149736854513);
            transE.put(Character.valueOf('S'), -0.8085250474669937);
            trans.put(Character.valueOf('E'), transE);
            HashMap<Character, Double> transM = new HashMap<Character, Double>();
            transM.put(Character.valueOf('E'), -0.33344856811948514);
            transM.put(Character.valueOf('M'), -1.2603623820268226);
            trans.put(Character.valueOf('M'), transM);
            HashMap<Character, Double> transS = new HashMap<Character, Double>();
            transS.put(Character.valueOf('B'), -0.7211965654669841);
            transS.put(Character.valueOf('S'), -0.6658631448798212);
            trans.put(Character.valueOf('S'), transS);
            InputStream is = this.getClass().getResourceAsStream(PROB_EMIT);
            try {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                    emit = new HashMap<Character, Map<Character, Double>>();
                    HashMap<Character, Double> values = null;
                    while (br.ready()) {
                        String line = br.readLine();
                        String[] tokens = line.split("\t");
                        if (tokens.length == 1) {
                            values = new HashMap<Character, Double>();
                            emit.put(Character.valueOf(tokens[0].charAt(0)), values);
                            continue;
                        }
                        values.put(Character.valueOf(tokens[0].charAt(0)), Double.valueOf(tokens[1]));
                    }
                }
                catch (IOException e) {
                    System.err.println(String.format(Locale.getDefault(), "%s: load model failure!", PROB_EMIT));
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block16;
                    }
                    catch (IOException e2) {
                        System.err.println(String.format(Locale.getDefault(), "%s: close failure!", PROB_EMIT));
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    System.err.println(String.format(Locale.getDefault(), "%s: close failure!", PROB_EMIT));
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                System.err.println(String.format(Locale.getDefault(), "%s: close failure!", PROB_EMIT));
            }
        }
        System.out.println(String.format(Locale.getDefault(), "model load finished, time elapsed %d ms.", System.currentTimeMillis() - s));
    }

    public void cut(String sentence, List<String> tokens) {
        StringBuilder chinese = new StringBuilder();
        StringBuilder other = new StringBuilder();
        int i = 0;
        while (i < sentence.length()) {
            char ch = sentence.charAt(i);
            if (CharacterUtil.isChineseLetter(ch)) {
                if (other.length() > 0) {
                    this.processOtherUnknownWords(other.toString(), tokens);
                    other = new StringBuilder();
                }
                chinese.append(ch);
            } else {
                if (chinese.length() > 0) {
                    this.viterbi(chinese.toString(), tokens);
                    chinese = new StringBuilder();
                }
                other.append(ch);
            }
            ++i;
        }
        if (chinese.length() > 0) {
            this.viterbi(chinese.toString(), tokens);
        } else {
            this.processOtherUnknownWords(other.toString(), tokens);
        }
    }

    public void viterbi(String sentence, List<String> tokens) {
        Vector v = new Vector();
        HashMap<Character, Node> path = new HashMap<Character, Node>();
        v.add(new HashMap());
        char[] cArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            char state = cArray[n2];
            Double emP = emit.get(Character.valueOf(state)).get(Character.valueOf(sentence.charAt(0)));
            if (emP == null) {
                emP = MIN_FLOAT;
            }
            ((Map)v.get(0)).put(Character.valueOf(state), start.get(Character.valueOf(state)) + emP);
            path.put(Character.valueOf(state), new Node(Character.valueOf(state), null));
            ++n2;
        }
        int i = 1;
        while (i < sentence.length()) {
            HashMap<Character, Double> vv = new HashMap<Character, Double>();
            v.add(vv);
            HashMap<Character, Node> newPath = new HashMap<Character, Node>();
            char[] cArray2 = states;
            int n3 = states.length;
            int emP = 0;
            while (emP < n3) {
                char y = cArray2[emP];
                Double emp = emit.get(Character.valueOf(y)).get(Character.valueOf(sentence.charAt(i)));
                if (emp == null) {
                    emp = MIN_FLOAT;
                }
                Pair<Character> candidate = null;
                char[] cArray3 = prevStatus.get(Character.valueOf(y));
                int n4 = cArray3.length;
                int n5 = 0;
                while (n5 < n4) {
                    char y0 = cArray3[n5];
                    Double tranp = trans.get(Character.valueOf(y0)).get(Character.valueOf(y));
                    if (tranp == null) {
                        tranp = MIN_FLOAT;
                    }
                    tranp = tranp + (emp + (Double)((Map)v.get(i - 1)).get(Character.valueOf(y0)));
                    if (candidate == null) {
                        candidate = new Pair<Character>(Character.valueOf(y0), tranp);
                    } else if (candidate.freq <= tranp) {
                        candidate.freq = tranp;
                        candidate.key = Character.valueOf(y0);
                    }
                    ++n5;
                }
                vv.put(Character.valueOf(y), candidate.freq);
                newPath.put(Character.valueOf(y), new Node(Character.valueOf(y), (Node)path.get(candidate.key)));
                ++emP;
            }
            path = newPath;
            ++i;
        }
        double probE = (Double)((Map)v.get(sentence.length() - 1)).get(Character.valueOf('E'));
        double probS = (Double)((Map)v.get(sentence.length() - 1)).get(Character.valueOf('S'));
        Vector<Character> posList = new Vector<Character>(sentence.length());
        Node win = probE < probS ? (Node)path.get(Character.valueOf('S')) : (Node)path.get(Character.valueOf('E'));
        while (win != null) {
            posList.add(win.value);
            win = win.parent;
        }
        Collections.reverse(posList);
        int begin = 0;
        int next = 0;
        int i2 = 0;
        while (i2 < sentence.length()) {
            char pos = ((Character)posList.get(i2)).charValue();
            if (pos == 'B') {
                begin = i2;
            } else if (pos == 'E') {
                tokens.add(sentence.substring(begin, i2 + 1));
                next = i2 + 1;
            } else if (pos == 'S') {
                tokens.add(sentence.substring(i2, i2 + 1));
                next = i2 + 1;
            }
            ++i2;
        }
        if (next < sentence.length()) {
            tokens.add(sentence.substring(next));
        }
    }

    private void processOtherUnknownWords(String other, List<String> tokens) {
        Matcher mat = CharacterUtil.reSkip.matcher(other);
        int offset = 0;
        while (mat.find()) {
            if (mat.start() > offset) {
                tokens.add(other.substring(offset, mat.start()));
            }
            tokens.add(mat.group());
            offset = mat.end();
        }
        if (offset < other.length()) {
            tokens.add(other.substring(offset));
        }
    }
}

