/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.util.Preconditions;
import com.google.common.base.Optional;
import com.google.common.io.Closeables;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public final class HttpsCertificate {
    private static final String PROTOCOL = "TLS";
    private static final String DEFAULT_ALGORITHM = "SunX509";
    private final ContentResource resource;
    private final String keyStorePassword;
    private final String certPassword;

    private HttpsCertificate(ContentResource resource, String keyStorePassword, String certPassword) {
        this.resource = resource;
        this.keyStorePassword = keyStorePassword;
        this.certPassword = certPassword;
    }

    public SSLEngine createSSLEngine() {
        return this.createServerContext().createSSLEngine();
    }

    private SSLContext createServerContext() {
        InputStream is = this.getKeyStore();
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(is, this.getKeyStorePassword());
            KeyManagerFactory factory = KeyManagerFactory.getInstance(HttpsCertificate.getAlgorithm());
            factory.init(keyStore, this.getCertPassword());
            SSLContext serverContext = SSLContext.getInstance(PROTOCOL);
            serverContext.init(factory.getKeyManagers(), null, null);
            SSLContext sSLContext = serverContext;
            return sSLContext;
        }
        catch (Exception e) {
            throw new MocoException("Failed to initialize the server-side SSLContext", e);
        }
        finally {
            Closeables.closeQuietly((InputStream)is);
        }
    }

    private static String getAlgorithm() {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            return DEFAULT_ALGORITHM;
        }
        return algorithm;
    }

    private InputStream getKeyStore() {
        MessageContent messageContent = this.resource.readFor((Optional<? extends Request>)Optional.absent());
        return messageContent.toInputStream();
    }

    private char[] getKeyStorePassword() {
        return this.keyStorePassword.toCharArray();
    }

    private char[] getCertPassword() {
        return this.certPassword.toCharArray();
    }

    public static HttpsCertificate certificate(ContentResource resource, String keyStorePassword, String certPassword) {
        return new HttpsCertificate((ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)resource), Preconditions.checkNotNullOrEmpty(keyStorePassword, "Key store password should not be null"), Preconditions.checkNotNullOrEmpty(certPassword, "Cert password should not be null"));
    }
}

