/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.CookieAttribute;
import com.github.dreamhead.moco.HttpMethod;
import com.github.dreamhead.moco.HttpProtocolVersion;
import com.github.dreamhead.moco.HttpServer;
import com.github.dreamhead.moco.HttpsCertificate;
import com.github.dreamhead.moco.HttpsServer;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEvent;
import com.github.dreamhead.moco.MocoEventAction;
import com.github.dreamhead.moco.MocoEventTrigger;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.MocoProcedure;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.SocketServer;
import com.github.dreamhead.moco.action.MocoAsyncAction;
import com.github.dreamhead.moco.action.MocoGetRequestAction;
import com.github.dreamhead.moco.action.MocoPostRequestAction;
import com.github.dreamhead.moco.config.MocoContextConfig;
import com.github.dreamhead.moco.config.MocoFileRootConfig;
import com.github.dreamhead.moco.config.MocoRequestConfig;
import com.github.dreamhead.moco.config.MocoResponseConfig;
import com.github.dreamhead.moco.extractor.CookieRequestExtractor;
import com.github.dreamhead.moco.extractor.Extractors;
import com.github.dreamhead.moco.extractor.FormRequestExtractor;
import com.github.dreamhead.moco.extractor.HeaderRequestExtractor;
import com.github.dreamhead.moco.extractor.JsonPathRequestExtractor;
import com.github.dreamhead.moco.extractor.ParamRequestExtractor;
import com.github.dreamhead.moco.extractor.PlainExtractor;
import com.github.dreamhead.moco.extractor.XPathRequestExtractor;
import com.github.dreamhead.moco.handler.AndResponseHandler;
import com.github.dreamhead.moco.handler.HeaderResponseHandler;
import com.github.dreamhead.moco.handler.ProcedureResponseHandler;
import com.github.dreamhead.moco.handler.ProxyBatchResponseHandler;
import com.github.dreamhead.moco.handler.ProxyResponseHandler;
import com.github.dreamhead.moco.handler.ResponseHandlers;
import com.github.dreamhead.moco.handler.SequenceHandler;
import com.github.dreamhead.moco.handler.StatusCodeResponseHandler;
import com.github.dreamhead.moco.handler.failover.Failover;
import com.github.dreamhead.moco.handler.failover.FailoverStrategy;
import com.github.dreamhead.moco.handler.proxy.ProxyConfig;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.ActualSocketServer;
import com.github.dreamhead.moco.internal.ApiUtils;
import com.github.dreamhead.moco.matcher.AndRequestMatcher;
import com.github.dreamhead.moco.matcher.EqRequestMatcher;
import com.github.dreamhead.moco.matcher.ExistMatcher;
import com.github.dreamhead.moco.matcher.NotRequestMatcher;
import com.github.dreamhead.moco.matcher.OrRequestMatcher;
import com.github.dreamhead.moco.matcher.XmlRequestMatcher;
import com.github.dreamhead.moco.monitor.StdLogWriter;
import com.github.dreamhead.moco.procedure.LatencyProcedure;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.ResourceFactory;
import com.github.dreamhead.moco.resource.reader.ExtractorVariable;
import com.github.dreamhead.moco.resource.reader.Variable;
import com.github.dreamhead.moco.util.Iterables;
import com.github.dreamhead.moco.util.Jsons;
import com.github.dreamhead.moco.util.Preconditions;
import com.github.dreamhead.moco.util.URLs;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;

public final class Moco {
    public static HttpServer httpServer(int port, MocoConfig ... configs) {
        com.google.common.base.Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualHttpServer.createQuietServer((Optional<Integer>)Optional.of((Object)port), configs);
    }

    public static HttpServer httpServer(int port, MocoMonitor monitor, MocoConfig ... configs) {
        com.google.common.base.Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualHttpServer.createHttpServerWithMonitor((Optional<Integer>)Optional.of((Object)port), (MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), (MocoConfig[])com.google.common.base.Preconditions.checkNotNull((Object)configs, (Object)"Configuration should not be null"));
    }

    public static HttpServer httpServer(int port, MocoMonitor monitor, MocoMonitor monitor2, MocoMonitor ... monitors) {
        com.google.common.base.Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualHttpServer.createHttpServerWithMonitor((Optional<Integer>)Optional.of((Object)port), ApiUtils.mergeMonitor((MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), (MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor2, (Object)"Monitor should not be null"), (MocoMonitor[])com.google.common.base.Preconditions.checkNotNull((Object)monitors, (Object)"Monitors should not be null")), new MocoConfig[0]);
    }

    public static HttpServer httpServer(MocoConfig ... configs) {
        return ActualHttpServer.createQuietServer((Optional<Integer>)Optional.absent(), (MocoConfig[])com.google.common.base.Preconditions.checkNotNull((Object)configs, (Object)"Configuration should not be null"));
    }

    public static HttpServer httpServer(MocoMonitor monitor, MocoConfig ... configs) {
        return ActualHttpServer.createHttpServerWithMonitor((Optional<Integer>)Optional.absent(), (MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), configs);
    }

    public static HttpsServer httpsServer(int port, HttpsCertificate certificate, MocoConfig ... configs) {
        com.google.common.base.Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualHttpServer.createHttpsQuietServer((Optional<Integer>)Optional.of((Object)port), (HttpsCertificate)com.google.common.base.Preconditions.checkNotNull((Object)certificate, (Object)"Certificate should not be null"), configs);
    }

    public static HttpsServer httpsServer(int port, HttpsCertificate certificate, MocoMonitor monitor, MocoConfig ... configs) {
        com.google.common.base.Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualHttpServer.createHttpsServerWithMonitor((Optional<Integer>)Optional.of((Object)port), (HttpsCertificate)com.google.common.base.Preconditions.checkNotNull((Object)certificate, (Object)"Certificate should not be null"), (MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), configs);
    }

    public static HttpsServer httpsServer(HttpsCertificate certificate, MocoConfig ... configs) {
        return ActualHttpServer.createHttpsQuietServer((Optional<Integer>)Optional.absent(), (HttpsCertificate)com.google.common.base.Preconditions.checkNotNull((Object)certificate, (Object)"Certificate should not be null"), configs);
    }

    public static HttpsServer httpsServer(HttpsCertificate certificate, MocoMonitor monitor, MocoConfig ... configs) {
        return ActualHttpServer.createHttpsServerWithMonitor((Optional<Integer>)Optional.absent(), (HttpsCertificate)com.google.common.base.Preconditions.checkNotNull((Object)certificate, (Object)"Certificate should not be null"), (MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), configs);
    }

    public static HttpServer httpsServer(int port, HttpsCertificate certificate, MocoMonitor monitor, MocoMonitor monitor2, MocoMonitor ... monitors) {
        com.google.common.base.Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualHttpServer.createHttpsServerWithMonitor((Optional<Integer>)Optional.of((Object)port), (HttpsCertificate)com.google.common.base.Preconditions.checkNotNull((Object)certificate, (Object)"Certificate should not be null"), ApiUtils.mergeMonitor((MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), (MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor2, (Object)"Monitor should not be null"), monitors), new MocoConfig[0]);
    }

    public static SocketServer socketServer() {
        return ActualSocketServer.createQuietServer((Optional<Integer>)Optional.absent());
    }

    public static SocketServer socketServer(int port) {
        return ActualSocketServer.createQuietServer((Optional<Integer>)Optional.of((Object)port));
    }

    public static SocketServer socketServer(int port, MocoMonitor monitor) {
        com.google.common.base.Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualSocketServer.createServerWithMonitor((Optional<Integer>)Optional.of((Object)port), (MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"));
    }

    public static SocketServer socketServer(int port, MocoMonitor monitor, MocoMonitor monitor2, MocoMonitor ... monitors) {
        com.google.common.base.Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualSocketServer.createServerWithMonitor((Optional<Integer>)Optional.of((Object)port), ApiUtils.mergeMonitor((MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), (MocoMonitor)com.google.common.base.Preconditions.checkNotNull((Object)monitor2, (Object)"Monitor should not be null"), monitors));
    }

    public static MocoConfig context(String context) {
        return new MocoContextConfig(Preconditions.checkNotNullOrEmpty(context, "Context should not be null"));
    }

    public static MocoConfig request(RequestMatcher matcher) {
        return new MocoRequestConfig((RequestMatcher)com.google.common.base.Preconditions.checkNotNull((Object)matcher, (Object)"Request matcher should not be null"));
    }

    public static MocoConfig response(ResponseHandler handler) {
        return new MocoResponseConfig((ResponseHandler)com.google.common.base.Preconditions.checkNotNull((Object)handler, (Object)"Response handler should not be null"));
    }

    public static MocoConfig fileRoot(String fileRoot) {
        return new MocoFileRootConfig(Preconditions.checkNotNullOrEmpty(fileRoot, "File root should not be null"));
    }

    public static MocoMonitor log() {
        return ApiUtils.log(new StdLogWriter());
    }

    public static MocoMonitor log(String filename) {
        return ApiUtils.log(ApiUtils.fileLogWriter(Preconditions.checkNotNullOrEmpty(filename, "Filename should not be null or empty"), (Optional<Charset>)Optional.absent()));
    }

    public static MocoMonitor log(String filename, Charset charset) {
        return ApiUtils.log(ApiUtils.fileLogWriter(Preconditions.checkNotNullOrEmpty(filename, "Filename should not be null or empty"), (Optional<Charset>)Optional.of((Object)com.google.common.base.Preconditions.checkNotNull((Object)charset, (Object)"Charset should not be null"))));
    }

    public static RequestMatcher by(String content) {
        return Moco.by(Moco.text(Preconditions.checkNotNullOrEmpty(content, "Content should not be null")));
    }

    public static RequestMatcher by(Resource resource) {
        com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null");
        return ApiUtils.by(Extractors.extractor(resource.id()), resource);
    }

    public static <T> RequestMatcher eq(RequestExtractor<T> extractor, String expected) {
        return Moco.eq((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), Moco.text((String)com.google.common.base.Preconditions.checkNotNull((Object)expected, (Object)"Expected content should not be null")));
    }

    public static <T> RequestMatcher eq(RequestExtractor<T> extractor, Resource expected) {
        return new EqRequestMatcher((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), (Resource)com.google.common.base.Preconditions.checkNotNull((Object)expected, (Object)"Expected content should not be null"));
    }

    public static RequestMatcher match(Resource resource) {
        return ApiUtils.match(Extractors.extractor(resource.id()), (Resource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null"));
    }

    public static <T> RequestMatcher match(RequestExtractor<T> extractor, String expected) {
        return ApiUtils.match((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), Moco.text(Preconditions.checkNotNullOrEmpty(expected, "Expected content should not be null")));
    }

    public static <T> RequestMatcher exist(RequestExtractor<T> extractor) {
        return new ExistMatcher((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"));
    }

    public static RequestMatcher startsWith(Resource resource) {
        return ApiUtils.startsWith(Extractors.extractor(resource.id()), (Resource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null"));
    }

    public static <T> RequestMatcher startsWith(RequestExtractor<T> extractor, String expected) {
        return ApiUtils.startsWith((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), Moco.text(Preconditions.checkNotNullOrEmpty(expected, "Expected resource should not be null")));
    }

    public static RequestMatcher endsWith(Resource resource) {
        return ApiUtils.endsWith(Extractors.extractor(resource.id()), (Resource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null"));
    }

    public static <T> RequestMatcher endsWith(RequestExtractor<T> extractor, String expected) {
        return ApiUtils.endsWith((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), Moco.text(Preconditions.checkNotNullOrEmpty(expected, "Expected resource should not be null")));
    }

    public static RequestMatcher contain(Resource resource) {
        return ApiUtils.contain(Extractors.extractor(resource.id()), (Resource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null"));
    }

    public static <T> RequestMatcher contain(RequestExtractor<T> extractor, String expected) {
        return ApiUtils.contain((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), Moco.text(Preconditions.checkNotNullOrEmpty(expected, "Expected resource should not be null")));
    }

    public static RequestMatcher and(RequestMatcher matcher, RequestMatcher ... matchers) {
        return new AndRequestMatcher(Iterables.asIterable(com.google.common.base.Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"), (Object[])com.google.common.base.Preconditions.checkNotNull((Object)matchers, (Object)"Matcher should not be null")));
    }

    public static ResponseHandler and(ResponseHandler handler, ResponseHandler ... handlers) {
        return AndResponseHandler.and((ResponseHandler)com.google.common.base.Preconditions.checkNotNull((Object)handler, (Object)"Handlers should not be null"), (ResponseHandler[])com.google.common.base.Preconditions.checkNotNull((Object)handlers, (Object)"Handlers should not be null"));
    }

    public static RequestMatcher or(RequestMatcher matcher, RequestMatcher ... matchers) {
        return new OrRequestMatcher(Iterables.asIterable(com.google.common.base.Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"), (Object[])com.google.common.base.Preconditions.checkNotNull((Object)matchers, (Object)"Matcher should not be null")));
    }

    public static RequestMatcher not(RequestMatcher matcher) {
        return new NotRequestMatcher((RequestMatcher)com.google.common.base.Preconditions.checkNotNull((Object)matcher, (Object)"Expected matcher should not be null"));
    }

    public static ContentResource text(String text) {
        return ResourceFactory.textResource((String)com.google.common.base.Preconditions.checkNotNull((Object)text, (Object)"Text should not be null"));
    }

    public static ResponseHandler with(String text) {
        return Moco.with(Moco.text(Preconditions.checkNotNullOrEmpty(text, "Text should not be null")));
    }

    public static ResponseHandler with(Resource resource) {
        return ResponseHandlers.responseHandler((Resource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null"));
    }

    public static ResponseHandler with(MocoProcedure procedure) {
        return new ProcedureResponseHandler((MocoProcedure)com.google.common.base.Preconditions.checkNotNull((Object)procedure, (Object)"Procedure should not be null"));
    }

    public static Resource uri(String uri) {
        return ResourceFactory.uriResource(Preconditions.checkNotNullOrEmpty(uri, "URI should not be null"));
    }

    public static Resource method(String httpMethod) {
        return ResourceFactory.methodResource(Preconditions.checkNotNullOrEmpty(httpMethod, "HTTP method should not be null"));
    }

    public static Resource method(HttpMethod httpMethod) {
        return ResourceFactory.methodResource(((HttpMethod)((Object)com.google.common.base.Preconditions.checkNotNull((Object)((Object)httpMethod), (Object)"HTTP method should not be null"))).toString());
    }

    public static RequestExtractor<String[]> header(String header) {
        return new HeaderRequestExtractor(Preconditions.checkNotNullOrEmpty(header, "Header name should not be null"));
    }

    public static ResponseHandler header(String name, String value) {
        return Moco.header(Preconditions.checkNotNullOrEmpty(name, "Header name should not be null"), Moco.text(Preconditions.checkNotNullOrEmpty(value, "Header value should not be null")));
    }

    public static ResponseHandler header(String name, Resource value) {
        return new HeaderResponseHandler(Preconditions.checkNotNullOrEmpty(name, "Header name should not be null"), (Resource)com.google.common.base.Preconditions.checkNotNull((Object)value, (Object)"Header value should not be null"));
    }

    public static RequestExtractor<String> cookie(String key) {
        return new CookieRequestExtractor(Preconditions.checkNotNullOrEmpty(key, "Cookie key should not be null"));
    }

    public static ResponseHandler cookie(String key, String value, CookieAttribute ... attributes) {
        return Moco.cookie(Preconditions.checkNotNullOrEmpty(key, "Cookie key should not be null"), Moco.text(Preconditions.checkNotNullOrEmpty(value, "Cookie value should not be null")), (CookieAttribute[])com.google.common.base.Preconditions.checkNotNull((Object)attributes, (Object)"Cookie options should not be null"));
    }

    public static ResponseHandler cookie(String key, Resource resource, CookieAttribute ... attributes) {
        return Moco.header("Set-Cookie", ResourceFactory.cookieResource(Preconditions.checkNotNullOrEmpty(key, "Cookie key should not be null"), (Resource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Cookie value should not be null"), (CookieAttribute[])com.google.common.base.Preconditions.checkNotNull((Object)attributes, (Object)"Cookie options should not be null")));
    }

    public static RequestExtractor<String> form(String key) {
        return new FormRequestExtractor(Preconditions.checkNotNullOrEmpty(key, "Form key should not be null"));
    }

    public static LatencyProcedure latency(long duration, TimeUnit unit) {
        com.google.common.base.Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0, (Object)"Latency must be greater than zero");
        return new LatencyProcedure(duration, (TimeUnit)((Object)com.google.common.base.Preconditions.checkNotNull((Object)((Object)unit), (Object)"Time unit should not be null")));
    }

    public static RequestExtractor<String[]> query(String param) {
        return new ParamRequestExtractor(Preconditions.checkNotNullOrEmpty(param, "Query parameter should not be null"));
    }

    public static XPathRequestExtractor xpath(String xpath) {
        return new XPathRequestExtractor(Preconditions.checkNotNullOrEmpty(xpath, "XPath should not be null"));
    }

    public static RequestMatcher xml(String resource) {
        return Moco.xml(Moco.text(Preconditions.checkNotNullOrEmpty(resource, "Resource should not be null")));
    }

    public static RequestMatcher xml(Resource resource) {
        com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null");
        return new XmlRequestMatcher(resource);
    }

    public static ContentResource json(String jsonText) {
        return Moco.json(Moco.text(Preconditions.checkNotNullOrEmpty(jsonText, "Json should not be null")));
    }

    public static ContentResource json(Resource resource) {
        return ResourceFactory.jsonResource((Resource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Json should not be null"));
    }

    public static ContentResource json(Object pojo) {
        return ResourceFactory.jsonResource(com.google.common.base.Preconditions.checkNotNull((Object)pojo, (Object)"Json object should not be null"));
    }

    public static JsonPathRequestExtractor jsonPath(String jsonPath) {
        return new JsonPathRequestExtractor(Preconditions.checkNotNullOrEmpty(jsonPath, "JsonPath should not be null"));
    }

    public static ResponseHandler seq(String content, String ... contents) {
        com.google.common.base.Preconditions.checkNotNull((Object)content, (Object)"Sequence content should not be null");
        com.google.common.base.Preconditions.checkArgument((contents.length > 0 ? 1 : 0) != 0, (Object)"Sequence content should not be null");
        return SequenceHandler.newSeq((Iterable<ResponseHandler>)FluentIterable.from(Iterables.asIterable(content, contents)).transform(ApiUtils.textToResource()));
    }

    public static ResponseHandler seq(Resource content, Resource ... contents) {
        com.google.common.base.Preconditions.checkNotNull((Object)content, (Object)"Sequence content should not be null");
        com.google.common.base.Preconditions.checkArgument((contents.length > 0 ? 1 : 0) != 0, (Object)"Sequence contents should not be null");
        return SequenceHandler.newSeq((Iterable<ResponseHandler>)FluentIterable.from(Iterables.asIterable(content, contents)).transform(ApiUtils.resourceToResourceHandler()));
    }

    public static ResponseHandler seq(ResponseHandler handler, ResponseHandler ... handlers) {
        com.google.common.base.Preconditions.checkNotNull((Object)handler, (Object)"Sequence handler should not be null");
        com.google.common.base.Preconditions.checkArgument((handlers.length > 0 ? 1 : 0) != 0, (Object)"Sequence handlers should not be null");
        return SequenceHandler.newSeq(Iterables.asIterable(handler, handlers));
    }

    public static ContentResource file(String filename) {
        return Moco.file(Moco.text(Preconditions.checkNotNullOrEmpty(filename, "Filename should not be null")));
    }

    public static ContentResource file(Resource filename) {
        return Moco.file((Resource)com.google.common.base.Preconditions.checkNotNull((Object)filename, (Object)"Filename should not be null"), (Optional<Charset>)Optional.absent());
    }

    public static ContentResource file(String filename, Charset charset) {
        return Moco.file((Resource)Moco.text(Preconditions.checkNotNullOrEmpty(filename, "Filename should not be null")), (Optional<Charset>)Optional.of((Object)com.google.common.base.Preconditions.checkNotNull((Object)charset, (Object)"Charset should not be null")));
    }

    public static ContentResource file(Resource filename, Charset charset) {
        return Moco.file((Resource)com.google.common.base.Preconditions.checkNotNull((Object)filename, (Object)"Filename should not be null"), (Optional<Charset>)Optional.of((Object)com.google.common.base.Preconditions.checkNotNull((Object)charset, (Object)"Charset should not be null")));
    }

    private static ContentResource file(Resource filename, Optional<Charset> charset) {
        return ResourceFactory.fileResource((Resource)com.google.common.base.Preconditions.checkNotNull((Object)filename, (Object)"Filename should not be null"), charset, (Optional<MocoConfig>)Optional.absent());
    }

    public static ContentResource pathResource(String filename) {
        return Moco.pathResource(Moco.text(Preconditions.checkNotNullOrEmpty(filename, "Filename should not be null")));
    }

    public static ContentResource pathResource(Resource filename) {
        return Moco.pathResource((Resource)com.google.common.base.Preconditions.checkNotNull((Object)filename, (Object)"Filename should not be null"), (Optional<Charset>)Optional.absent());
    }

    public static ContentResource pathResource(String filename, Charset charset) {
        return Moco.pathResource((Resource)Moco.text(Preconditions.checkNotNullOrEmpty(filename, "Filename should not be null")), (Optional<Charset>)Optional.of((Object)com.google.common.base.Preconditions.checkNotNull((Object)charset, (Object)"Charset should not be null")));
    }

    public static ContentResource pathResource(Resource filename, Charset charset) {
        return Moco.pathResource((Resource)com.google.common.base.Preconditions.checkNotNull((Object)filename, (Object)"Filename should not be null"), (Optional<Charset>)Optional.of((Object)com.google.common.base.Preconditions.checkNotNull((Object)charset, (Object)"Charset should not be null")));
    }

    private static ContentResource pathResource(Resource filename, Optional<Charset> charset) {
        return ResourceFactory.classpathFileResource((Resource)com.google.common.base.Preconditions.checkNotNull((Object)filename, (Object)"Filename should not be null"), charset);
    }

    public static Resource version(String version) {
        return Moco.version(HttpProtocolVersion.versionOf(Preconditions.checkNotNullOrEmpty(version, "Version should not be null")));
    }

    public static Resource version(Resource resource) {
        return ResourceFactory.versionResource((Resource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Version should not be null"));
    }

    public static Resource version(HttpProtocolVersion version) {
        return ResourceFactory.versionResource((HttpProtocolVersion)((Object)com.google.common.base.Preconditions.checkNotNull((Object)((Object)version), (Object)"Version should not be null")));
    }

    public static ResponseHandler status(int code) {
        com.google.common.base.Preconditions.checkArgument((code > 0 ? 1 : 0) != 0, (Object)"Status code must be greater than zero");
        return new StatusCodeResponseHandler(code);
    }

    public static ResponseHandler proxy(String url) {
        return Moco.proxy(Preconditions.checkNotNullOrEmpty(url, "URL should not be null"), Failover.DEFAULT_FAILOVER);
    }

    public static ResponseHandler proxy(ContentResource url) {
        return Moco.proxy((ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)url, (Object)"URL should not be null"), Failover.DEFAULT_FAILOVER);
    }

    public static ResponseHandler proxy(String url, Failover failover) {
        return Moco.proxy(Moco.text(Preconditions.checkNotNullOrEmpty(url, "URL should not be null")), (Failover)com.google.common.base.Preconditions.checkNotNull((Object)failover, (Object)"Failover should not be null"));
    }

    public static ResponseHandler proxy(ContentResource url, Failover failover) {
        return new ProxyResponseHandler(URLs.toUrlFunction((Resource)com.google.common.base.Preconditions.checkNotNull((Object)url, (Object)"URL should not be null")), (Failover)com.google.common.base.Preconditions.checkNotNull((Object)failover, (Object)"Failover should not be null"));
    }

    public static ResponseHandler proxy(ProxyConfig proxyConfig) {
        return Moco.proxy((ProxyConfig)com.google.common.base.Preconditions.checkNotNull((Object)proxyConfig), Failover.DEFAULT_FAILOVER);
    }

    public static ResponseHandler proxy(ProxyConfig proxyConfig, Failover failover) {
        return new ProxyBatchResponseHandler((ProxyConfig)com.google.common.base.Preconditions.checkNotNull((Object)proxyConfig), (Failover)com.google.common.base.Preconditions.checkNotNull((Object)failover));
    }

    public static ProxyConfig.Builder from(String localBase) {
        return ProxyConfig.builder(Preconditions.checkNotNullOrEmpty(localBase, "Local base should not be null"));
    }

    public static ContentResource template(String template) {
        return Moco.template(Moco.text(Preconditions.checkNotNullOrEmpty(template, "Template should not be null")));
    }

    public static ContentResource template(String template, String name, String value) {
        return Moco.template(Moco.text(Preconditions.checkNotNullOrEmpty(template, "Template should not be null")), Preconditions.checkNotNullOrEmpty(name, "Template variable name should not be null"), Preconditions.checkNotNullOrEmpty(value, "Template variable value should not be null"));
    }

    public static ContentResource template(String template, String name1, String value1, String name2, String value2) {
        return Moco.template(Moco.text(Preconditions.checkNotNullOrEmpty(template, "Template should not be null")), Preconditions.checkNotNullOrEmpty(name1, "Template variable name should not be null"), Preconditions.checkNotNullOrEmpty(value1, "Template variable value should not be null"), Preconditions.checkNotNullOrEmpty(name2, "Template variable name should not be null"), Preconditions.checkNotNullOrEmpty(value2, "Template variable value should not be null"));
    }

    public static ContentResource template(ContentResource resource) {
        return Moco.template((ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Template should not be null"), ImmutableMap.of());
    }

    public static ContentResource template(ContentResource template, String name, String value) {
        return Moco.template((ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)template, (Object)"Template should not be null"), Preconditions.checkNotNullOrEmpty(name, "Template variable name should not be null"), Moco.var(Preconditions.checkNotNullOrEmpty(value, "Template variable value should not be null")));
    }

    public static ContentResource template(ContentResource template, String name1, String value1, String name2, String value2) {
        return Moco.template((ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)template, (Object)"Template should not be null"), Preconditions.checkNotNullOrEmpty(name1, "Template variable name should not be null"), Moco.var(Preconditions.checkNotNullOrEmpty(value1, "Template variable value should not be null")), Preconditions.checkNotNullOrEmpty(name2, "Template variable name should not be null"), Moco.var(Preconditions.checkNotNullOrEmpty(value2, "Template variable value should not be null")));
    }

    public static <T> ContentResource template(String template, String name, RequestExtractor<T> extractor) {
        return Moco.template(Moco.text(Preconditions.checkNotNullOrEmpty(template, "Template should not be null")), Preconditions.checkNotNullOrEmpty(name, "Template variable name should not be null"), (RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor, (Object)"Template variable extractor should not be null"));
    }

    public static <ExtractorType1, ExtractorType2> ContentResource template(String template, String name1, RequestExtractor<ExtractorType1> extractor1, String name2, RequestExtractor<ExtractorType2> extractor2) {
        return Moco.template(Moco.text(Preconditions.checkNotNullOrEmpty(template, "Template should not be null")), Preconditions.checkNotNullOrEmpty(name1, "Template variable name should not be null"), (RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor1, (Object)"Template variable extractor should not be null"), Preconditions.checkNotNullOrEmpty(name2, "Template variable name should not be null"), (RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor2, (Object)"Template variable extractor should not be null"));
    }

    public static <T> ContentResource template(ContentResource template, String name, RequestExtractor<T> extractor) {
        return ResourceFactory.templateResource((ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)template, (Object)"Template should not be null"), (ImmutableMap<String, ? extends Variable>)ImmutableMap.of((Object)Preconditions.checkNotNullOrEmpty(name, "Template variable name should not be null"), new ExtractorVariable((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor, (Object)"Template variable extractor should not be null"))));
    }

    public static <ExtractorType1, ExtractorType2> ContentResource template(ContentResource template, String name1, RequestExtractor<ExtractorType1> extractor1, String name2, RequestExtractor<ExtractorType2> extractor2) {
        return ResourceFactory.templateResource((ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)template, (Object)"Template should not be null"), (ImmutableMap<String, ? extends Variable>)ImmutableMap.of((Object)Preconditions.checkNotNullOrEmpty(name1, "Template variable name should not be null"), new ExtractorVariable((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor1, (Object)"Template variable extractor should not be null")), (Object)Preconditions.checkNotNullOrEmpty(name2, "Template variable name should not be null"), new ExtractorVariable((RequestExtractor)com.google.common.base.Preconditions.checkNotNull(extractor2, (Object)"Template variable extractor should not be null"))));
    }

    public static ContentResource template(String template, ImmutableMap<String, ? extends RequestExtractor<?>> variables) {
        return Moco.template(Moco.text((String)com.google.common.base.Preconditions.checkNotNull((Object)template, (Object)"Template should not be null")), (ImmutableMap)com.google.common.base.Preconditions.checkNotNull(variables, (Object)"Template variable should not be null"));
    }

    public static ContentResource template(ContentResource template, ImmutableMap<String, ? extends RequestExtractor<?>> variables) {
        return ResourceFactory.templateResource((ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)template, (Object)"Template should not be null"), ApiUtils.toVariables((ImmutableMap)com.google.common.base.Preconditions.checkNotNull(variables, (Object)"Template variable should not be null")));
    }

    public static RequestExtractor<Object> var(Object text) {
        return new PlainExtractor<Object>(com.google.common.base.Preconditions.checkNotNull((Object)text, (Object)"Template variable should not be null or empty"));
    }

    public static Failover failover(String file) {
        return new Failover(ApiUtils.failoverExecutor(Preconditions.checkNotNullOrEmpty(file, "Filename should not be null")), FailoverStrategy.FAILOVER);
    }

    public static Failover playback(String file) {
        return new Failover(ApiUtils.failoverExecutor(Preconditions.checkNotNullOrEmpty(file, "Filename should not be null")), FailoverStrategy.PLAYBACK);
    }

    public static MocoEventTrigger complete(MocoEventAction action) {
        return new MocoEventTrigger(MocoEvent.COMPLETE, (MocoEventAction)com.google.common.base.Preconditions.checkNotNull((Object)action, (Object)"Action should not be null"));
    }

    public static MocoEventAction async(MocoEventAction action) {
        return Moco.async((MocoEventAction)com.google.common.base.Preconditions.checkNotNull((Object)action, (Object)"Action should not be null"), Moco.latency(1000L, TimeUnit.MILLISECONDS));
    }

    public static MocoEventAction async(MocoEventAction action, LatencyProcedure procedure) {
        return new MocoAsyncAction((MocoEventAction)com.google.common.base.Preconditions.checkNotNull((Object)action, (Object)"Action should not be null"), (LatencyProcedure)com.google.common.base.Preconditions.checkNotNull((Object)procedure, (Object)"Procedure should not be null"));
    }

    public static MocoEventAction get(String url) {
        return Moco.get(Moco.text(Preconditions.checkNotNullOrEmpty(url, "URL should not be null")));
    }

    public static MocoEventAction get(Resource url) {
        return new MocoGetRequestAction((Resource)com.google.common.base.Preconditions.checkNotNull((Object)url, (Object)"URL should not be null"));
    }

    public static MocoEventAction post(Resource url, ContentResource content) {
        return new MocoPostRequestAction((Resource)com.google.common.base.Preconditions.checkNotNull((Object)url, (Object)"URL should not be null"), (ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)content, (Object)"Content should not be null"));
    }

    public static MocoEventAction post(String url, ContentResource content) {
        return Moco.post((Resource)Moco.text(Preconditions.checkNotNullOrEmpty(url, "URL should not be null")), (ContentResource)com.google.common.base.Preconditions.checkNotNull((Object)content, (Object)"Content should not be null"));
    }

    public static MocoEventAction post(String url, String content) {
        return Moco.post(Preconditions.checkNotNullOrEmpty(url, "URL should not be null"), Moco.text(Preconditions.checkNotNullOrEmpty(content, "Content should not be null")));
    }

    public static MocoEventAction post(Resource url, String content) {
        return Moco.post((Resource)com.google.common.base.Preconditions.checkNotNull((Object)url, (Object)"URL should not be null"), Moco.text(Preconditions.checkNotNullOrEmpty(content, "Content should not be null")));
    }

    public static MocoEventAction post(Resource url, Object object) {
        return Moco.post((Resource)com.google.common.base.Preconditions.checkNotNull((Object)url, (Object)"URL should not be null"), Jsons.toJson(com.google.common.base.Preconditions.checkNotNull((Object)object, (Object)"Content should not be null")));
    }

    public static ResponseHandler attachment(String filename, Resource resource) {
        return AndResponseHandler.and(Moco.header("Content-Disposition", String.format("attachment; filename=%s", Preconditions.checkNotNullOrEmpty(filename, "Filename should not be null or empty"))), Moco.with((Resource)com.google.common.base.Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null")));
    }

    private Moco() {
    }
}

