/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.mount.MountPredicate;
import com.github.dreamhead.moco.mount.MountTo;
import com.github.dreamhead.moco.util.Preconditions;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;

public final class MocoMount {
    public static MountTo to(String target) {
        return new MountTo(Preconditions.checkNotNullOrEmpty(target, "Target should not be null"));
    }

    public static MountPredicate include(String glob) {
        Preconditions.checkNotNullOrEmpty(glob, "Glob should not be null or empty");
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        return new MountPredicate(){

            public boolean apply(String filename) {
                return matcher.matches(Paths.get(filename, new String[0]));
            }
        };
    }

    public static MountPredicate exclude(String glob) {
        return MocoMount.not(MocoMount.include(Preconditions.checkNotNullOrEmpty(glob, "Glob should not be null")));
    }

    private static MountPredicate not(final MountPredicate predicate) {
        com.google.common.base.Preconditions.checkNotNull((Object)predicate);
        return new MountPredicate(){

            public boolean apply(String filename) {
                return !predicate.apply(filename);
            }
        };
    }

    private MocoMount() {
    }
}

