/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.HttpServer;
import com.github.dreamhead.moco.HttpsServer;
import com.github.dreamhead.moco.Runnable;
import com.github.dreamhead.moco.SocketServer;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.ActualSocketServer;
import com.github.dreamhead.moco.internal.MocoHttpServer;
import com.github.dreamhead.moco.internal.MocoSocketServer;
import com.google.common.base.Preconditions;

public abstract class Runner {
    public static void running(HttpServer httpServer, Runnable runnable) throws Exception {
        Runner.doRunning(Runner.runner((HttpServer)Preconditions.checkNotNull((Object)httpServer)), (Runnable)Preconditions.checkNotNull((Object)runnable));
    }

    public static void running(HttpsServer httpServer, Runnable runnable) throws Exception {
        Runner.doRunning(Runner.runner((HttpServer)Preconditions.checkNotNull((Object)httpServer)), (Runnable)Preconditions.checkNotNull((Object)runnable));
    }

    public static void running(SocketServer server, Runnable runnable) throws Exception {
        Runner.doRunning(Runner.runner((SocketServer)Preconditions.checkNotNull((Object)server)), (Runnable)Preconditions.checkNotNull((Object)runnable));
    }

    private static void doRunning(Runner server, Runnable runnable) throws Exception {
        try {
            server.start();
            runnable.run();
        }
        finally {
            server.stop();
        }
    }

    public static Runner runner(HttpServer server) {
        return new MocoHttpServer((ActualHttpServer)Preconditions.checkNotNull((Object)server, (Object)"Server should not be null"));
    }

    public static Runner runner(SocketServer server) {
        return new MocoSocketServer((ActualSocketServer)Preconditions.checkNotNull((Object)server, (Object)"Server should not be null"));
    }

    public abstract void start();

    public abstract void stop();
}

