/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestMatcher;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;

public final class VerificationData {
    private final Iterable<Request> requests;
    private final RequestMatcher matcher;
    private final String mismatchFormat;

    public VerificationData(Iterable<Request> requests, RequestMatcher matcher, String mismatchFormat) {
        this.requests = requests;
        this.matcher = matcher;
        this.mismatchFormat = mismatchFormat;
    }

    public String mismatchDescription(int actualSize, String expected) {
        return String.format(this.mismatchFormat, expected, actualSize);
    }

    public final int matchedSize() {
        return FluentIterable.from(this.requests).filter(this.matched()).size();
    }

    private Predicate<Request> matched() {
        return new Predicate<Request>(){

            public boolean apply(Request request) {
                return VerificationData.this.matcher.match(request);
            }
        };
    }
}

