/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.action;

import com.github.dreamhead.moco.MocoEventAction;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public abstract class MocoRequestAction
implements MocoEventAction {
    private final Resource url;

    protected abstract HttpRequestBase createRequest(String var1, Request var2);

    protected MocoRequestAction(Resource url) {
        this.url = url;
    }

    protected Resource getUrl() {
        return this.url;
    }

    @Override
    public void execute(Request request) {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            this.doExecute(client, request);
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    private void doExecute(CloseableHttpClient client, Request request) throws IOException {
        String targetUrl = this.url.readFor((Optional<? extends Request>)Optional.of((Object)request)).toString();
        client.execute((HttpUriRequest)this.createRequest(targetUrl, request));
    }
}

