/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.dumper;

import com.github.dreamhead.moco.HttpMessage;
import com.google.common.net.MediaType;
import io.netty.util.internal.StringUtil;

public final class HttpDumpers {
    public static String asContent(HttpMessage message) {
        long length = HttpDumpers.getContentLength(message, -1L);
        if (length > 0L) {
            return StringUtil.NEWLINE + StringUtil.NEWLINE + HttpDumpers.contentForDump(message);
        }
        return "";
    }

    private static String contentForDump(HttpMessage message) {
        String type = (String)message.getHeaders().get((Object)"Content-Type");
        if (HttpDumpers.isText(type)) {
            return message.getContent().toString();
        }
        return "<content is binary>";
    }

    private static boolean isText(String type) {
        try {
            MediaType mediaType = MediaType.parse((String)type);
            return mediaType.is(MediaType.ANY_TEXT_TYPE) || mediaType.subtype().endsWith("javascript") || mediaType.subtype().endsWith("json") || mediaType.subtype().endsWith("xml") || mediaType.is(MediaType.FORM_DATA);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static long getContentLength(HttpMessage response, long defaultValue) {
        String lengthText = (String)response.getHeaders().get((Object)"Content-Length");
        if (lengthText != null) {
            try {
                return Long.parseLong(lengthText);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private HttpDumpers() {
    }
}

