/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.dumper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.github.dreamhead.moco.dumper.InternalMessageContent;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.util.Strings;
import java.io.IOException;

public final class MessageContentDeserializer
extends JsonDeserializer<MessageContent> {
    public MessageContent deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            return MessageContent.content(Strings.strip(jp.getText()));
        }
        if (currentToken == JsonToken.START_OBJECT) {
            InternalMessageContent content = (InternalMessageContent)jp.readValueAs(InternalMessageContent.class);
            return content.toContent();
        }
        return (MessageContent)ctx.handleUnexpectedToken(MessageContent.class, jp);
    }
}

