/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpRequestExtractor;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.extractor.HeaderRequestExtractor;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Set;

public class CookiesRequestExtractor
extends HttpRequestExtractor<ImmutableMap<String, String>> {
    private final RequestExtractor<String[]> extractor = new HeaderRequestExtractor("Cookie");

    @Override
    protected Optional<ImmutableMap<String, String>> doExtract(HttpRequest request) {
        Optional<String[]> cookieString = this.extractor.extract(request);
        if (!cookieString.isPresent()) {
            return Optional.absent();
        }
        return Optional.of(CookiesRequestExtractor.doExtractCookies((String[])cookieString.get()));
    }

    private static ImmutableMap<String, String> doExtractCookies(String[] cookieStrings) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String cookie : cookieStrings) {
            Set decodeCookies = ServerCookieDecoder.STRICT.decode(cookie);
            for (Cookie decodeCookie : decodeCookies) {
                builder.put((Object)decodeCookie.name(), (Object)decodeCookie.value());
            }
        }
        return builder.build();
    }
}

