/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpRequestExtractor;
import com.github.dreamhead.moco.util.HttpHeaders;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class HeaderRequestExtractor
extends HttpRequestExtractor<String[]> {
    private final String name;

    public HeaderRequestExtractor(String name) {
        this.name = name;
    }

    @Override
    protected Optional<String[]> doExtract(HttpRequest request) {
        ImmutableMap<String, String> headers = request.getHeaders();
        String[] extractedValues = (String[])FluentIterable.from((Iterable)headers.entrySet()).filter(HttpHeaders.isForHeaderName(this.name)).transform(this.toValue()).toArray(String.class);
        if (extractedValues.length > 0) {
            return Optional.of((Object)extractedValues);
        }
        return Optional.absent();
    }

    private Function<Map.Entry<String, String>, String> toValue() {
        return new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> input) {
                return input.getValue();
            }
        };
    }
}

