/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpRequestExtractor;
import com.github.dreamhead.moco.extractor.ContentRequestExtractor;
import com.github.dreamhead.moco.model.MessageContent;
import com.google.common.base.Optional;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class JsonPathRequestExtractor
extends HttpRequestExtractor<Object> {
    private final ContentRequestExtractor extractor = new ContentRequestExtractor();
    private final JsonPath jsonPath;

    public JsonPathRequestExtractor(String jsonPath) {
        this.jsonPath = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    protected Optional<Object> doExtract(HttpRequest request) {
        Optional<MessageContent> requestBody = this.extractor.extract(request);
        try {
            if (!requestBody.isPresent()) {
                return Optional.absent();
            }
            MessageContent content = (MessageContent)requestBody.get();
            Object jsonPathContent = this.jsonPath.read((InputStream)new ByteArrayInputStream(content.getContent()), content.getCharset().toString(), Configuration.defaultConfiguration());
            if (jsonPathContent == null) {
                return Optional.absent();
            }
            return Optional.of((Object)this.toStringArray(jsonPathContent));
        }
        catch (PathNotFoundException e) {
            return Optional.absent();
        }
        catch (IOException e) {
            return Optional.absent();
        }
    }

    private Object toStringArray(Object content) {
        if (content instanceof List) {
            List texts = (List)content;
            return texts.toArray(new String[texts.size()]);
        }
        return content.toString();
    }
}

