/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpResponse;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.MutableHttpResponse;
import com.github.dreamhead.moco.handler.AbstractHttpResponseHandler;
import com.github.dreamhead.moco.handler.failover.Failover;
import com.github.dreamhead.moco.model.DefaultHttpRequest;
import com.github.dreamhead.moco.model.DefaultHttpResponse;
import com.github.dreamhead.moco.util.URLs;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyResponseHandler
extends AbstractHttpResponseHandler {
    private static final ImmutableSet<String> IGNORED_REQUEST_HEADERS = ImmutableSet.of((Object)"Host", (Object)"Content-Length");
    private static final ImmutableSet<String> IGNORED_RESPONSE_HEADERS = ImmutableSet.of((Object)"Date", (Object)"Server");
    private static CloseableHttpClient client;
    private static Logger logger;
    private final Failover failover;

    protected abstract Optional<String> doRemoteUrl(HttpRequest var1);

    protected AbstractProxyResponseHandler(Failover failover) {
        this.failover = failover;
    }

    private HttpRequestBase prepareRemoteRequest(FullHttpRequest request, URL url) {
        HttpRequestBase remoteRequest = this.createRemoteRequest(request, url);
        remoteRequest.setConfig(this.createRequestConfig());
        long contentLength = HttpUtil.getContentLength((HttpMessage)request, (int)-1);
        if (contentLength > 0L && remoteRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)remoteRequest;
            entityRequest.setEntity(this.createEntity(request.content(), contentLength));
        }
        return remoteRequest;
    }

    private RequestConfig createRequestConfig() {
        return RequestConfig.custom().setRedirectsEnabled(false).setSocketTimeout(0).setStaleConnectionCheckEnabled(true).build();
    }

    private HttpRequestBase createRemoteRequest(FullHttpRequest request, URL url) {
        HttpRequestBase remoteRequest = this.createBaseRequest(url, request.method());
        remoteRequest.setProtocolVersion((ProtocolVersion)this.createVersion(request));
        for (Map.Entry entry : request.headers()) {
            if (!this.isRequestHeader(entry)) continue;
            remoteRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return remoteRequest;
    }

    private HttpEntity createEntity(ByteBuf content, long contentLength) {
        return new InputStreamEntity((InputStream)new ByteBufInputStream(content), contentLength);
    }

    private org.apache.http.HttpVersion createVersion(FullHttpRequest request) {
        HttpVersion protocolVersion = request.protocolVersion();
        return new org.apache.http.HttpVersion(protocolVersion.majorVersion(), protocolVersion.minorVersion());
    }

    private boolean isRequestHeader(Map.Entry<String, String> entry) {
        return !IGNORED_REQUEST_HEADERS.contains((Object)entry.getKey());
    }

    private boolean isResponseHeader(Header header) {
        return !IGNORED_RESPONSE_HEADERS.contains((Object)header.getName());
    }

    private HttpRequestBase createBaseRequest(URL url, HttpMethod method) {
        if (method == HttpMethod.GET) {
            return new HttpGet(url.toString());
        }
        if (method == HttpMethod.POST) {
            return new HttpPost(url.toString());
        }
        if (method == HttpMethod.PUT) {
            return new HttpPut(url.toString());
        }
        if (method == HttpMethod.DELETE) {
            return new HttpDelete(url.toString());
        }
        if (method == HttpMethod.HEAD) {
            return new HttpHead(url.toString());
        }
        if (method == HttpMethod.OPTIONS) {
            return new HttpOptions(url.toString());
        }
        if (method == HttpMethod.TRACE) {
            return new HttpTrace(url.toString());
        }
        throw new MocoException("unknown HTTP method");
    }

    private HttpResponse setupResponse(HttpRequest request, org.apache.http.HttpResponse remoteResponse) throws IOException {
        int statusCode = remoteResponse.getStatusLine().getStatusCode();
        if (statusCode == HttpResponseStatus.BAD_REQUEST.code()) {
            return this.failover.failover(request);
        }
        HttpResponse httpResponse = this.setupNormalResponse(remoteResponse);
        this.failover.onCompleteResponse(request, httpResponse);
        return httpResponse;
    }

    private HttpResponse setupNormalResponse(org.apache.http.HttpResponse remoteResponse) throws IOException {
        byte[] content;
        Header[] allHeaders;
        HttpVersion httpVersion = HttpVersion.valueOf((String)remoteResponse.getProtocolVersion().toString());
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)remoteResponse.getStatusLine().getStatusCode());
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, status);
        response.setStatus(status);
        for (Header header : allHeaders = remoteResponse.getAllHeaders()) {
            if (!this.isResponseHeader(header)) continue;
            response.headers().set(header.getName(), (Object)header.getValue());
        }
        HttpEntity entity = remoteResponse.getEntity();
        if (entity != null && (content = EntityUtils.toByteArray((HttpEntity)entity)).length > 0) {
            ByteBuf buffer = Unpooled.copiedBuffer((byte[])content);
            response.content().writeBytes(buffer);
        }
        return DefaultHttpResponse.newResponse((FullHttpResponse)response);
    }

    @Override
    protected final void doWriteToResponse(HttpRequest httpRequest, MutableHttpResponse httpResponse) {
        Optional<URL> url = this.remoteUrl(httpRequest);
        if (!url.isPresent()) {
            return;
        }
        HttpResponse response = this.doProxy(httpRequest, (URL)url.get());
        this.doWritHttpResponse(response, httpResponse);
    }

    private void doWritHttpResponse(HttpResponse response, MutableHttpResponse httpResponse) {
        httpResponse.setVersion(response.getVersion());
        httpResponse.setStatus(response.getStatus());
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            httpResponse.addHeader((String)entry.getKey(), entry.getValue());
        }
        httpResponse.setContent(response.getContent());
    }

    private HttpResponse doProxy(HttpRequest request, URL remoteUrl) {
        if (this.failover.isPlayback()) {
            try {
                return this.failover.failover(request);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.doForward(request, remoteUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse doForward(HttpRequest request, URL remoteUrl) {
        try {
            HttpRequestBase remoteRequest = this.prepareRemoteRequest(request, remoteUrl);
            HttpResponse httpResponse = this.setupResponse(request, (org.apache.http.HttpResponse)client.execute((HttpUriRequest)remoteRequest));
            return httpResponse;
        }
        catch (IOException e) {
            logger.error("Failed to load remote and try to failover", (Throwable)e);
            HttpResponse httpResponse = this.failover.failover(request);
            return httpResponse;
        }
        finally {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
    }

    private HttpRequestBase prepareRemoteRequest(HttpRequest request, URL remoteUrl) {
        FullHttpRequest httpRequest = ((DefaultHttpRequest)request).toFullHttpRequest();
        return this.prepareRemoteRequest(httpRequest, remoteUrl);
    }

    private Optional<URL> remoteUrl(HttpRequest request) {
        Optional<String> remoteUrl = this.doRemoteUrl(request);
        if (!remoteUrl.isPresent()) {
            return Optional.absent();
        }
        QueryStringEncoder encoder = new QueryStringEncoder((String)remoteUrl.get());
        for (Map.Entry entry : request.getQueries().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                encoder.addParam((String)entry.getKey(), value);
            }
        }
        try {
            return Optional.of((Object)URLs.toUrl(encoder.toString()));
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }

    protected final Failover failover() {
        return this.failover;
    }

    static {
        try {
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
            SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
            client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setConnectionManagerShared(true).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new MocoException(e);
        }
        logger = LoggerFactory.getLogger(AbstractProxyResponseHandler.class);
    }
}

