/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.util.Iterables;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;

public final class AndResponseHandler
extends AbstractResponseHandler {
    private final Iterable<ResponseHandler> handlers;

    private AndResponseHandler(Iterable<ResponseHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void writeToResponse(SessionContext context) {
        for (ResponseHandler handler : this.handlers) {
            handler.writeToResponse(context);
        }
    }

    @Override
    public ResponseHandler apply(MocoConfig config) {
        if (config.isFor("response")) {
            return super.apply(config);
        }
        return AndResponseHandler.and((Iterable<ResponseHandler>)FluentIterable.from(this.handlers).transform(this.applyConfig(config)));
    }

    private Function<ResponseHandler, ResponseHandler> applyConfig(final MocoConfig config) {
        return new Function<ResponseHandler, ResponseHandler>(){

            public ResponseHandler apply(ResponseHandler handler) {
                return (ResponseHandler)handler.apply(config);
            }
        };
    }

    public static ResponseHandler and(Iterable<ResponseHandler> handlers) {
        return new AndResponseHandler(handlers);
    }

    public static ResponseHandler and(ResponseHandler handler, ResponseHandler ... handlers) {
        if (handlers.length == 0) {
            return handler;
        }
        return new AndResponseHandler(Iterables.asIterable(handler, handlers));
    }
}

