/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MutableHttpResponse;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractHttpResponseHandler;
import com.github.dreamhead.moco.handler.HeaderDetector;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.Optional;

public class HeaderResponseHandler
extends AbstractHttpResponseHandler {
    private final HeaderDetector detector = new HeaderDetector();
    private final String name;
    private final Resource resource;

    public HeaderResponseHandler(String name, Resource resource) {
        this.name = name;
        this.resource = resource;
    }

    @Override
    protected void doWriteToResponse(HttpRequest httpRequest, MutableHttpResponse httpResponse) {
        if (this.detector.hasHeader(httpResponse, this.name)) {
            httpResponse.removeHeader(this.name);
        }
        String value = this.resource.readFor((Optional<? extends Request>)Optional.of((Object)httpRequest)).toString();
        httpResponse.addHeader(this.name, value);
    }

    @Override
    public ResponseHandler apply(MocoConfig config) {
        Resource appliedResource = this.resource.apply(config);
        if (appliedResource != this.resource) {
            return new HeaderResponseHandler(this.name, appliedResource);
        }
        return super.apply(config);
    }
}

