/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractProxyResponseHandler;
import com.github.dreamhead.moco.handler.failover.Failover;
import com.github.dreamhead.moco.handler.proxy.ProxyConfig;
import com.google.common.base.Optional;

public class ProxyBatchResponseHandler
extends AbstractProxyResponseHandler {
    private final ProxyConfig proxyConfig;

    public ProxyBatchResponseHandler(ProxyConfig proxyConfig, Failover failover) {
        super(failover);
        this.proxyConfig = proxyConfig;
    }

    @Override
    protected Optional<String> doRemoteUrl(HttpRequest request) {
        String uri = request.getUri();
        if (!this.proxyConfig.canAccessedBy(uri)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.proxyConfig.remoteUrl(uri));
    }

    @Override
    public ResponseHandler apply(MocoConfig config) {
        if (config.isFor("uri")) {
            String newLocalBase = config.apply(this.proxyConfig.localBase());
            return new ProxyBatchResponseHandler(Moco.from(newLocalBase).to(this.proxyConfig.remoteBase()), this.failover());
        }
        return this;
    }
}

