/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.ContentHandler;
import com.github.dreamhead.moco.handler.JsonResponseHandler;
import com.github.dreamhead.moco.handler.VersionResponseHandler;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;

public final class ResponseHandlers {
    private static final ImmutableMap<String, Class> HANDLERS = ImmutableMap.builder().put((Object)"file", ContentHandler.class).put((Object)"text", ContentHandler.class).put((Object)"pathresource", ContentHandler.class).put((Object)"template", ContentHandler.class).put((Object)"version", VersionResponseHandler.class).put((Object)"json", JsonResponseHandler.class).build();

    public static ResponseHandler responseHandler(Resource resource) {
        if (HANDLERS.containsKey((Object)resource.id())) {
            return ResponseHandlers.createResponseHandler(resource);
        }
        throw new IllegalArgumentException(String.format("unknown response handler for [%s]", resource.id()));
    }

    private static ResponseHandler createResponseHandler(Resource resource) {
        Class clazz = (Class)HANDLERS.get((Object)resource.id());
        try {
            Constructor<?>[] constructors = clazz.getConstructors();
            return (ResponseHandler)constructors[0].newInstance(resource);
        }
        catch (Exception e) {
            throw new MocoException(e);
        }
    }

    private ResponseHandlers() {
    }
}

