/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.internal.SessionContext;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public final class SequenceHandler
extends AbstractResponseHandler {
    private final ImmutableList<ResponseHandler> handlers;
    private int index;

    private SequenceHandler(Iterable<ResponseHandler> handlers) {
        this.handlers = ImmutableList.copyOf(handlers);
    }

    public static ResponseHandler newSeq(Iterable<ResponseHandler> handlers) {
        Preconditions.checkArgument((Iterables.size(handlers) > 0 ? 1 : 0) != 0, (Object)"Sequence contents should not be null");
        return new SequenceHandler(handlers);
    }

    @Override
    public void writeToResponse(SessionContext context) {
        ((ResponseHandler)this.handlers.get(this.current())).writeToResponse(context);
    }

    private int current() {
        int current = this.index++;
        if (this.index >= this.handlers.size()) {
            this.index = this.handlers.size() - 1;
        }
        return current;
    }

    @Override
    public ResponseHandler apply(MocoConfig config) {
        if (config.isFor("response")) {
            return super.apply(config);
        }
        FluentIterable transformedResources = FluentIterable.from((Iterable)ImmutableList.copyOf(this.handlers)).transform(this.applyConfig(config));
        return new SequenceHandler((Iterable<ResponseHandler>)transformedResources.toList());
    }

    private Function<ResponseHandler, ResponseHandler> applyConfig(final MocoConfig config) {
        return new Function<ResponseHandler, ResponseHandler>(){

            public ResponseHandler apply(ResponseHandler input) {
                return (ResponseHandler)input.apply(config);
            }
        };
    }
}

