/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler.failover;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpResponse;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.handler.failover.FailoverExecutor;
import com.github.dreamhead.moco.model.HttpRequestFailoverMatcher;
import com.github.dreamhead.moco.model.Session;
import com.github.dreamhead.moco.util.Jsons;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFailoverExecutor
implements FailoverExecutor {
    private static Logger logger = LoggerFactory.getLogger(DefaultFailoverExecutor.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final File file;

    public DefaultFailoverExecutor(File file) {
        this.file = file;
    }

    @Override
    public void onCompleteResponse(HttpRequest request, HttpResponse response) {
        try {
            ObjectWriter writer = this.mapper.writerWithDefaultPrettyPrinter();
            Session targetSession = Session.newSession(request, response);
            writer.writeValue(this.file, this.prepareTargetSessions(this.file, targetSession));
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    private ImmutableList<Session> prepareTargetSessions(File file, Session targetSession) {
        if (file.length() == 0L) {
            return ImmutableList.of((Object)targetSession);
        }
        return ImmutableList.builder().addAll(this.toUniqueSessions(targetSession, this.restoreSessions(file))).add((Object)targetSession).build();
    }

    private Iterable<Session> toUniqueSessions(Session targetSession, ImmutableList<Session> sessions) {
        Optional session = Iterables.tryFind(sessions, this.isForRequest(targetSession.getRequest()));
        if (session.isPresent()) {
            return FluentIterable.from(sessions).filter(Predicates.not(this.isForRequest(targetSession.getRequest())));
        }
        return sessions;
    }

    private ImmutableList<Session> restoreSessions(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            return Jsons.toObjects(inputStream, Session.class);
        }
        catch (MocoException me) {
            logger.error("exception found", (Throwable)me);
            return ImmutableList.of();
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    @Override
    public HttpResponse failover(HttpRequest request) {
        ImmutableList<Session> sessions = this.restoreSessions(this.file);
        Optional session = Iterables.tryFind(sessions, this.isForRequest(request));
        if (session.isPresent()) {
            return ((Session)session.get()).getResponse();
        }
        logger.error("No match request found: {}", (Object)request);
        throw new MocoException("no failover response found");
    }

    private Predicate<Session> isForRequest(final HttpRequest dumpedRequest) {
        return new Predicate<Session>(){

            public boolean apply(Session session) {
                HttpRequest request = session.getRequest();
                return new HttpRequestFailoverMatcher(request).match(dumpedRequest);
            }
        };
    }
}

