/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.HttpsCertificate;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.dumper.HttpRequestDumper;
import com.github.dreamhead.moco.dumper.HttpResponseDumper;
import com.github.dreamhead.moco.internal.HttpConfiguration;
import com.github.dreamhead.moco.monitor.QuietMonitor;
import com.github.dreamhead.moco.monitor.Slf4jMonitor;
import com.github.dreamhead.moco.monitor.ThreadSafeMonitor;
import com.github.dreamhead.moco.setting.HttpSetting;
import com.google.common.base.Optional;

public class ActualHttpServer
extends HttpConfiguration<ActualHttpServer> {
    private final Optional<HttpsCertificate> certificate;

    protected ActualHttpServer(Optional<Integer> port, Optional<HttpsCertificate> certificate, MocoMonitor monitor, MocoConfig ... configs) {
        super(port, monitor, configs);
        this.certificate = certificate;
    }

    public boolean isSecure() {
        return this.certificate.isPresent();
    }

    public Optional<HttpsCertificate> getCertificate() {
        return this.certificate;
    }

    @Override
    protected ActualHttpServer createMergeServer(ActualHttpServer thatServer) {
        return this.newBaseServer((Optional<Integer>)this.getPort().or(thatServer.getPort()), (Optional<HttpsCertificate>)this.certificate.or(thatServer.certificate));
    }

    private ActualHttpServer newBaseServer(Optional<Integer> port, Optional<HttpsCertificate> certificate) {
        if (certificate.isPresent()) {
            return ActualHttpServer.createHttpsLogServer(port, (HttpsCertificate)certificate.get(), new MocoConfig[0]);
        }
        return ActualHttpServer.createLogServer(port, new MocoConfig[0]);
    }

    public static ActualHttpServer createHttpServerWithMonitor(Optional<Integer> port, MocoMonitor monitor, MocoConfig ... configs) {
        return new ActualHttpServer(port, (Optional<HttpsCertificate>)Optional.absent(), new ThreadSafeMonitor(monitor), configs);
    }

    public static ActualHttpServer createLogServer(Optional<Integer> port, MocoConfig ... configs) {
        return ActualHttpServer.createHttpServerWithMonitor(port, new Slf4jMonitor(new HttpRequestDumper(), new HttpResponseDumper()), configs);
    }

    public static ActualHttpServer createQuietServer(Optional<Integer> port, MocoConfig ... configs) {
        return ActualHttpServer.createHttpServerWithMonitor(port, new QuietMonitor(), configs);
    }

    public static ActualHttpServer createHttpsServerWithMonitor(Optional<Integer> port, HttpsCertificate certificate, MocoMonitor monitor, MocoConfig ... configs) {
        return new ActualHttpServer(port, (Optional<HttpsCertificate>)Optional.of((Object)certificate), monitor, configs);
    }

    public static ActualHttpServer createHttpsLogServer(Optional<Integer> port, HttpsCertificate certificate, MocoConfig ... configs) {
        return ActualHttpServer.createHttpsServerWithMonitor(port, certificate, new Slf4jMonitor(new HttpRequestDumper(), new HttpResponseDumper()), configs);
    }

    public static ActualHttpServer createHttpsQuietServer(Optional<Integer> port, HttpsCertificate certificate, MocoConfig ... configs) {
        return ActualHttpServer.createHttpsServerWithMonitor(port, certificate, new QuietMonitor(), configs);
    }

    protected HttpSetting newSetting(RequestMatcher matcher) {
        return new HttpSetting(matcher);
    }
}

