/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.SocketResponseSetting;
import com.github.dreamhead.moco.SocketServer;
import com.github.dreamhead.moco.dumper.SocketRequestDumper;
import com.github.dreamhead.moco.dumper.SocketResponseDumper;
import com.github.dreamhead.moco.internal.BaseActualServer;
import com.github.dreamhead.moco.monitor.QuietMonitor;
import com.github.dreamhead.moco.monitor.Slf4jMonitor;
import com.github.dreamhead.moco.setting.Setting;
import com.github.dreamhead.moco.setting.SocketSetting;
import com.google.common.base.Optional;

public final class ActualSocketServer
extends BaseActualServer<SocketResponseSetting, ActualSocketServer>
implements SocketServer {
    private ActualSocketServer(Optional<Integer> port, MocoMonitor monitor) {
        super(port, monitor, new MocoConfig[0]);
    }

    @Override
    protected Setting<SocketResponseSetting> newSetting(RequestMatcher matcher) {
        return new SocketSetting(matcher);
    }

    @Override
    protected SocketResponseSetting onRequestAttached(RequestMatcher matcher) {
        SocketSetting baseSetting = new SocketSetting(matcher);
        this.addSetting(baseSetting);
        return baseSetting;
    }

    @Override
    protected ActualSocketServer createMergeServer(ActualSocketServer thatServer) {
        return this.newBaseServer((Optional<Integer>)this.getPort().or(thatServer.getPort()));
    }

    private ActualSocketServer newBaseServer(Optional<Integer> thisPort) {
        return ActualSocketServer.createLogServer(thisPort);
    }

    public static ActualSocketServer createQuietServer(Optional<Integer> port) {
        return new ActualSocketServer(port, new QuietMonitor());
    }

    public static ActualSocketServer createServerWithMonitor(Optional<Integer> port, MocoMonitor monitor) {
        return new ActualSocketServer(port, monitor);
    }

    public static ActualSocketServer createLogServer(Optional<Integer> port) {
        return new ActualSocketServer(port, new Slf4jMonitor(new SocketRequestDumper(), new SocketResponseDumper()));
    }
}

