/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.extractor.ContentRequestExtractor;
import com.github.dreamhead.moco.handler.failover.DefaultFailoverExecutor;
import com.github.dreamhead.moco.handler.failover.FailoverExecutor;
import com.github.dreamhead.moco.matcher.ContainMatcher;
import com.github.dreamhead.moco.matcher.EndsWithMatcher;
import com.github.dreamhead.moco.matcher.EqRequestMatcher;
import com.github.dreamhead.moco.matcher.JsonRequestMatcher;
import com.github.dreamhead.moco.matcher.MatchMatcher;
import com.github.dreamhead.moco.matcher.StartsWithMatcher;
import com.github.dreamhead.moco.monitor.CompositeMonitor;
import com.github.dreamhead.moco.monitor.DefaultLogFormatter;
import com.github.dreamhead.moco.monitor.FileLogWriter;
import com.github.dreamhead.moco.monitor.LogMonitor;
import com.github.dreamhead.moco.monitor.LogWriter;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.reader.ExtractorVariable;
import com.github.dreamhead.moco.resource.reader.Variable;
import com.github.dreamhead.moco.util.Iterables;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;

public final class ApiUtils {
    public static MocoMonitor mergeMonitor(MocoMonitor monitor, MocoMonitor monitor2, MocoMonitor[] monitors) {
        return new CompositeMonitor(Iterables.asIterable(monitor, monitor2, monitors));
    }

    private static Maps.EntryTransformer<String, RequestExtractor<?>, Variable> toVariable() {
        return new Maps.EntryTransformer<String, RequestExtractor<?>, Variable>(){

            public Variable transformEntry(String key, RequestExtractor<?> value) {
                return new ExtractorVariable(value);
            }
        };
    }

    public static ImmutableMap<String, Variable> toVariables(ImmutableMap<String, ? extends RequestExtractor<?>> variables) {
        return ImmutableMap.copyOf((Map)Maps.transformEntries(variables, ApiUtils.toVariable()));
    }

    public static Function<String, ResponseHandler> textToResource() {
        return new Function<String, ResponseHandler>(){

            public ResponseHandler apply(String content) {
                return Moco.with(Moco.text(content));
            }
        };
    }

    public static Function<Resource, ResponseHandler> resourceToResourceHandler() {
        return new Function<Resource, ResponseHandler>(){

            public ResponseHandler apply(Resource content) {
                return Moco.with(content);
            }
        };
    }

    public static FailoverExecutor failoverExecutor(String file) {
        return new DefaultFailoverExecutor(new File(file));
    }

    public static LogWriter fileLogWriter(String filename, Optional<Charset> charset) {
        return new FileLogWriter(filename, charset);
    }

    public static MocoMonitor log(LogWriter writer) {
        return new LogMonitor(new DefaultLogFormatter(), writer);
    }

    public static <T> RequestMatcher match(RequestExtractor<T> extractor, Resource expected) {
        return new MatchMatcher<T>(extractor, expected);
    }

    public static <T> RequestMatcher startsWith(RequestExtractor<T> extractor, Resource resource) {
        return new StartsWithMatcher<T>(extractor, resource);
    }

    public static <T> RequestMatcher endsWith(RequestExtractor<T> extractor, Resource resource) {
        return new EndsWithMatcher<T>(extractor, resource);
    }

    public static <T> RequestMatcher contain(RequestExtractor<T> extractor, Resource resource) {
        return new ContainMatcher<T>(extractor, resource);
    }

    public static <T> RequestMatcher by(RequestExtractor<T> extractor, Resource expected) {
        if ("json".equalsIgnoreCase(expected.id())) {
            return new JsonRequestMatcher(expected, (ContentRequestExtractor)ContentRequestExtractor.class.cast(extractor));
        }
        return new EqRequestMatcher<T>(extractor, expected);
    }

    private ApiUtils() {
    }
}

