/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.HttpMethod;
import com.github.dreamhead.moco.HttpResponseSetting;
import com.github.dreamhead.moco.HttpsServer;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.failover.Failover;
import com.github.dreamhead.moco.handler.proxy.ProxyConfig;
import com.github.dreamhead.moco.internal.BaseActualServer;
import com.github.dreamhead.moco.internal.InternalApis;
import com.github.dreamhead.moco.mount.MountHandler;
import com.github.dreamhead.moco.mount.MountMatcher;
import com.github.dreamhead.moco.mount.MountPredicate;
import com.github.dreamhead.moco.mount.MountTo;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.setting.HttpSetting;
import com.github.dreamhead.moco.util.RedirectDelegate;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;

public abstract class HttpConfiguration<T extends BaseActualServer>
extends BaseActualServer<HttpResponseSetting, T>
implements HttpsServer {
    private final RedirectDelegate delegate = new RedirectDelegate();

    protected HttpConfiguration(Optional<Integer> port, MocoMonitor monitor, MocoConfig[] configs) {
        super(port, monitor, configs);
    }

    @Override
    public HttpResponseSetting get(RequestMatcher matcher) {
        return this.requestByHttpMethod(HttpMethod.GET, (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"));
    }

    @Override
    public HttpResponseSetting post(RequestMatcher matcher) {
        return this.requestByHttpMethod(HttpMethod.POST, (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"));
    }

    @Override
    public HttpResponseSetting put(RequestMatcher matcher) {
        return this.requestByHttpMethod(HttpMethod.PUT, (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"));
    }

    @Override
    public HttpResponseSetting delete(RequestMatcher matcher) {
        return this.requestByHttpMethod(HttpMethod.DELETE, (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"));
    }

    @Override
    public HttpResponseSetting mount(String dir, MountTo target, MountPredicate ... predicates) {
        File mountedDir = new File(com.github.dreamhead.moco.util.Preconditions.checkNotNullOrEmpty(dir, "Directory should not be null"));
        Preconditions.checkNotNull((Object)target, (Object)"Target should not be null");
        return (HttpResponseSetting)((HttpResponseSetting)this.request((RequestMatcher)new MountMatcher(mountedDir, target, (Iterable<MountPredicate>)ImmutableList.copyOf((Object[])predicates)))).response(new MountHandler(mountedDir, target), new ResponseHandler[0]);
    }

    private HttpResponseSetting requestByHttpMethod(HttpMethod method, RequestMatcher matcher) {
        return (HttpResponseSetting)this.request(Moco.and(Moco.by(Moco.method(method)), matcher));
    }

    @Override
    public HttpResponseSetting proxy(ProxyConfig config) {
        return this.proxy((ProxyConfig)Preconditions.checkNotNull((Object)config, (Object)"Proxy config should not be null"), Failover.DEFAULT_FAILOVER);
    }

    @Override
    public HttpResponseSetting proxy(ProxyConfig proxyConfig, Failover failover) {
        ProxyConfig config = (ProxyConfig)Preconditions.checkNotNull((Object)proxyConfig, (Object)"Proxy config should not be null");
        ((HttpResponseSetting)this.request(InternalApis.context(config.localBase()))).response(Moco.proxy(config, (Failover)Preconditions.checkNotNull((Object)failover, (Object)"Failover should not be null")), new ResponseHandler[0]);
        return this;
    }

    @Override
    public HttpResponseSetting redirectTo(String url) {
        return this.delegate.redirectTo((HttpResponseSetting)this, url);
    }

    @Override
    public HttpResponseSetting redirectTo(Resource url) {
        return this.delegate.redirectTo((HttpResponseSetting)this, url);
    }

    @Override
    protected HttpResponseSetting onRequestAttached(RequestMatcher matcher) {
        HttpSetting baseSetting = new HttpSetting(matcher);
        this.addSetting(baseSetting);
        return baseSetting;
    }
}

