/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.HttpsCertificate;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.BaseActualServer;
import com.github.dreamhead.moco.internal.BaseServerRunner;
import com.github.dreamhead.moco.internal.MocoHandler;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class MocoHttpServer
extends BaseServerRunner {
    private final ActualHttpServer serverSetting;

    public MocoHttpServer(ActualHttpServer serverSetting) {
        this.serverSetting = serverSetting;
    }

    protected BaseActualServer serverSetting() {
        return this.serverSetting;
    }

    protected ChannelInitializer<SocketChannel> channelInitializer() {
        return new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (MocoHttpServer.this.serverSetting.isSecure()) {
                    pipeline.addFirst("ssl", (ChannelHandler)MocoHttpServer.this.sslHandler().get());
                }
                pipeline.addLast("codec", (ChannelHandler)new HttpServerCodec(4096, 8192, 8192, false));
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x100000));
                pipeline.addLast("handler", (ChannelHandler)new MocoHandler(MocoHttpServer.this.serverSetting));
            }
        };
    }

    private Optional<SslHandler> sslHandler() {
        return this.serverSetting.getCertificate().transform(this.toSslHandler());
    }

    private Function<HttpsCertificate, SslHandler> toSslHandler() {
        return new Function<HttpsCertificate, SslHandler>(){

            public SslHandler apply(HttpsCertificate certificate) {
                SSLEngine sslEngine = certificate.createSSLEngine();
                sslEngine.setUseClientMode(false);
                return new SslHandler(sslEngine);
            }
        };
    }
}

