/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.matcher;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.matcher.AbstractRequestMatcher;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;

public abstract class AbstractOperatorMatcher<T>
extends AbstractRequestMatcher {
    private final RequestExtractor<T> extractor;
    private final Resource expected;
    private final Predicate<String> predicate;

    protected abstract RequestMatcher newMatcher(RequestExtractor<T> var1, Resource var2);

    protected AbstractOperatorMatcher(RequestExtractor<T> extractor, Resource expected, Predicate<String> predicate) {
        this.extractor = extractor;
        this.predicate = predicate;
        this.expected = expected;
    }

    @Override
    public final boolean match(Request request) {
        Optional<T> extractContent = this.extractor.extract(request);
        if (!extractContent.isPresent()) {
            return false;
        }
        Object target = extractContent.get();
        if (target instanceof String) {
            return this.predicate.apply((Object)((String)target));
        }
        if (target instanceof String[]) {
            Object[] contents = (String[])target;
            return FluentIterable.from((Iterable)Lists.newArrayList((Object[])contents)).filter(Predicates.notNull()).anyMatch(this.predicate);
        }
        if (target instanceof MessageContent) {
            MessageContent actualTarget = (MessageContent)target;
            return this.predicate.apply((Object)actualTarget.toString());
        }
        return false;
    }

    @Override
    public final RequestMatcher doApply(MocoConfig config) {
        Resource appliedResource = this.expected.apply(config);
        if (appliedResource == this.expected) {
            return this;
        }
        return this.newMatcher(this.extractor, appliedResource);
    }
}

