/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.matcher;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.matcher.AbstractRequestMatcher;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;

public abstract class CompositeRequestMatcher
extends AbstractRequestMatcher {
    private final Iterable<RequestMatcher> matchers;

    protected abstract RequestMatcher newMatcher(Iterable<RequestMatcher> var1);

    protected CompositeRequestMatcher(Iterable<RequestMatcher> matchers) {
        this.matchers = matchers;
    }

    private Iterable<RequestMatcher> applyToMatchers(MocoConfig config) {
        FluentIterable appliedMatchers = FluentIterable.from(this.matchers).transform(this.applyConfig(config));
        if (this.matchers.equals(appliedMatchers)) {
            return this.matchers;
        }
        return appliedMatchers;
    }

    private Function<RequestMatcher, RequestMatcher> applyConfig(final MocoConfig config) {
        return new Function<RequestMatcher, RequestMatcher>(){

            public RequestMatcher apply(RequestMatcher matcher) {
                return (RequestMatcher)matcher.apply(config);
            }
        };
    }

    @Override
    public RequestMatcher doApply(MocoConfig config) {
        Iterable<RequestMatcher> appliedMatchers = this.applyToMatchers(config);
        if (appliedMatchers == this.matchers) {
            return this;
        }
        return this.newMatcher(appliedMatchers);
    }

    @Override
    public boolean match(Request request) {
        return this.doMatch(request, this.matchers);
    }

    protected abstract boolean doMatch(Request var1, Iterable<RequestMatcher> var2);
}

