/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.matcher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.extractor.ContentRequestExtractor;
import com.github.dreamhead.moco.matcher.AbstractRequestMatcher;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.Optional;
import java.io.IOException;

public class JsonRequestMatcher
extends AbstractRequestMatcher {
    private final ContentRequestExtractor extractor;
    private final ObjectMapper mapper;
    private final Resource expected;

    public JsonRequestMatcher(Resource expected, ContentRequestExtractor extractor) {
        this.extractor = extractor;
        this.expected = expected;
        this.mapper = new ObjectMapper();
    }

    @Override
    public boolean match(Request request) {
        Optional<MessageContent> content = this.extractor.extract(request);
        return content.isPresent() && this.doMatch(request, (MessageContent)content.get());
    }

    private boolean doMatch(Request request, MessageContent content) {
        try {
            JsonNode requestNode = this.mapper.readTree(content.toString());
            JsonNode resourceNode = this.mapper.readTree(this.expected.readFor((Optional<? extends Request>)Optional.of((Object)request)).toString());
            return requestNode.equals((Object)resourceNode);
        }
        catch (JsonProcessingException jpe) {
            return false;
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    @Override
    public RequestMatcher doApply(MocoConfig config) {
        Resource appliedResource = this.expected.apply(config);
        if (appliedResource == this.expected) {
            return this;
        }
        return new JsonRequestMatcher(appliedResource, this.extractor);
    }
}

