/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.HttpProtocolVersion;
import com.github.dreamhead.moco.HttpResponse;
import com.github.dreamhead.moco.model.DefaultHttpMessage;
import com.github.dreamhead.moco.model.MessageContent;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import java.io.InputStream;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class DefaultHttpResponse
extends DefaultHttpMessage
implements HttpResponse {
    private final int status;

    public DefaultHttpResponse(HttpProtocolVersion version, int status, ImmutableMap<String, String> headers, MessageContent content) {
        super(version, content, headers);
        this.status = status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public static DefaultHttpResponse newResponse(FullHttpResponse response) {
        ImmutableMap.Builder headerBuilder = ImmutableMap.builder();
        for (Map.Entry entry : response.headers()) {
            headerBuilder.put(entry);
        }
        return DefaultHttpResponse.builder().withVersion(DefaultHttpResponse.toHttpProtocolVersion(response.protocolVersion())).withStatus(response.status().code()).withHeaders((Map<String, String>)headerBuilder.build()).withContent(MessageContent.content().withContent((InputStream)new ByteBufInputStream(response.content())).build()).build();
    }

    private static HttpProtocolVersion toHttpProtocolVersion(HttpVersion httpVersion) {
        return HttpProtocolVersion.versionOf(httpVersion.text());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpProtocolVersion version;
        private MessageContent content;
        private ImmutableMap<String, String> headers;
        private int status;

        public Builder withVersion(HttpProtocolVersion version) {
            this.version = version;
            return this;
        }

        public Builder withContent(MessageContent content) {
            this.content = content;
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            if (headers != null) {
                this.headers = ImmutableMap.copyOf(headers);
            }
            return this;
        }

        public Builder withStatus(int code) {
            this.status = code;
            return this;
        }

        public DefaultHttpResponse build() {
            return new DefaultHttpResponse(this.version, this.status, this.headers, this.content);
        }
    }
}

