/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.github.dreamhead.moco.HttpMethod;
import com.github.dreamhead.moco.HttpProtocolVersion;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.model.MessageContent;
import com.google.common.base.Strings;
import java.util.Map;

public class HttpRequestFailoverMatcher {
    private final HttpRequest source;

    public HttpRequestFailoverMatcher(HttpRequest source) {
        this.source = source;
    }

    public boolean match(HttpRequest target) {
        return this.doMatch(this.source.getUri(), target.getUri()) && this.doMatch(this.source.getVersion(), target.getVersion()) && this.doMatch(this.source.getContent(), target.getContent()) && this.doMatch((Map<String, ?>)this.source.getHeaders(), (Map<String, ?>)target.getHeaders()) && this.doMatch(this.source.getMethod(), target.getMethod()) && this.doMatch((Map<String, ?>)this.source.getQueries(), (Map<String, ?>)target.getQueries());
    }

    protected boolean doMatch(Map<String, ?> thisField, Map<String, ?> thatField) {
        if (thisField == null || thisField.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, ?> entry : thisField.entrySet()) {
            String[] thatValues;
            String[] thisValues;
            Object thisValue = entry.getValue();
            Object thatValue = thatField.get(entry.getKey());
            if (thisValue instanceof String && thatValue instanceof String && !this.doMatch((String)thisValue, (String)thatValue)) {
                return false;
            }
            if (!(thisValue instanceof String[]) || !(thatValue instanceof String[]) || this.doMatch(thisValues = (String[])thisValue, thatValues = (String[])thatValue)) continue;
            return false;
        }
        return true;
    }

    private boolean doMatch(String[] thisValues, String[] thatValues) {
        if (thisValues.length != thatValues.length) {
            return false;
        }
        for (int i = 0; i < thatValues.length; ++i) {
            if (this.doMatch(thisValues[i], thatValues[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean doMatch(String thisField, String thatField) {
        return Strings.isNullOrEmpty((String)thisField) || thisField.equals(thatField);
    }

    protected boolean doMatch(HttpProtocolVersion thisField, HttpProtocolVersion thatField) {
        return thisField == null || thisField == thatField;
    }

    protected boolean doMatch(MessageContent thisField, MessageContent thatField) {
        return thisField == null || thisField.equals(thatField) || thatField != null && thisField.toString().equals(thatField.toString());
    }

    protected boolean doMatch(HttpMethod thisField, HttpMethod thatField) {
        return thisField == null || thisField == thatField;
    }
}

