/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.dumper.MessageContentDeserializer;
import com.github.dreamhead.moco.dumper.MessageContentSerializer;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

@JsonSerialize(using=MessageContentSerializer.class)
@JsonDeserialize(using=MessageContentDeserializer.class)
public class MessageContent {
    private byte[] content;
    private Optional<Charset> charset;

    public byte[] getContent() {
        return this.content;
    }

    public Charset getCharset() {
        return (Charset)this.charset.or((Object)Charset.defaultCharset());
    }

    public boolean hasCharset() {
        return this.charset.isPresent();
    }

    public boolean hasContent() {
        return this.content.length > 0;
    }

    public String toString() {
        return new String(this.content, this.getCharset());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageContent)) {
            return false;
        }
        MessageContent that = (MessageContent)obj;
        return Objects.equal(this.charset, that.charset) && Arrays.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Arrays.hashCode(this.content), this.charset});
    }

    public static Builder content() {
        return new Builder();
    }

    public static MessageContent content(String content) {
        return MessageContent.content().withContent(content).build();
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    static /* synthetic */ byte[] access$102(MessageContent x0, byte[] x1) {
        x0.content = x1;
        return x1;
    }

    public static class Builder {
        private byte[] content;
        private Charset charset;

        public Builder withContent(String content) {
            this.content = content.getBytes();
            return this;
        }

        public Builder withContent(InputStream is) {
            try {
                this.content = ByteStreams.toByteArray((InputStream)is);
                return this;
            }
            catch (IOException e) {
                throw new MocoException(e);
            }
        }

        public Builder withContent(byte[] content) {
            this.content = content;
            return this;
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public MessageContent build() {
            MessageContent messageContent = new MessageContent();
            messageContent.charset = Optional.fromNullable((Object)this.charset);
            MessageContent.access$102(messageContent, this.targetContent(this.content));
            return messageContent;
        }

        private byte[] targetContent(byte[] content) {
            if (content == null) {
                return new byte[0];
            }
            return this.content;
        }
    }
}

