/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.monitor;

import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.Response;
import com.github.dreamhead.moco.util.Locks;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ThreadSafeMonitor
implements MocoMonitor {
    private MocoMonitor monitor;
    private Lock lock = new ReentrantLock();

    public ThreadSafeMonitor(MocoMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void onMessageArrived(final Request request) {
        Locks.withLock(this.lock, new Runnable(){

            @Override
            public void run() {
                ThreadSafeMonitor.this.monitor.onMessageArrived(request);
            }
        });
    }

    @Override
    public void onException(final Throwable t) {
        Locks.withLock(this.lock, new Runnable(){

            @Override
            public void run() {
                ThreadSafeMonitor.this.monitor.onException(t);
            }
        });
    }

    @Override
    public void onMessageLeave(final Response response) {
        Locks.withLock(this.lock, new Runnable(){

            @Override
            public void run() {
                ThreadSafeMonitor.this.monitor.onMessageLeave(response);
            }
        });
    }

    @Override
    public void onUnexpectedMessage(final Request request) {
        Locks.withLock(this.lock, new Runnable(){

            @Override
            public void run() {
                ThreadSafeMonitor.this.monitor.onUnexpectedMessage(request);
            }
        });
    }
}

