/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.mount;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.matcher.AbstractRequestMatcher;
import com.github.dreamhead.moco.mount.MountPathExtractor;
import com.github.dreamhead.moco.mount.MountPredicate;
import com.github.dreamhead.moco.mount.MountTo;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import java.io.File;

public final class MountMatcher
extends AbstractRequestMatcher {
    private final MountPathExtractor extractor;
    private final File dir;
    private final Iterable<MountPredicate> predicates;
    private final MountTo target;

    public MountMatcher(File dir, MountTo target, Iterable<MountPredicate> predicates) {
        this.dir = dir;
        this.predicates = predicates;
        this.target = target;
        this.extractor = new MountPathExtractor(target);
    }

    @Override
    public boolean match(Request request) {
        Optional optionalPath = this.extractor.extract(request);
        if (optionalPath.isPresent()) {
            String relativePath = (String)optionalPath.get();
            return this.isTarget(relativePath) && new File(this.dir, relativePath).exists();
        }
        return false;
    }

    @Override
    public RequestMatcher doApply(MocoConfig config) {
        if (config.isFor("uri")) {
            return new MountMatcher(this.dir, this.target.apply(config), this.predicates);
        }
        if (config.isFor("file")) {
            return new MountMatcher(new File(config.apply(this.dir.getName())), this.target, this.predicates);
        }
        return this;
    }

    private boolean isTarget(String relativePath) {
        return !Strings.isNullOrEmpty((String)relativePath) && Predicates.and(this.predicates).apply((Object)relativePath);
    }
}

