/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.github.dreamhead.moco.util.FileContentType;
import com.google.common.base.Optional;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;

public abstract class AbstractFileResourceReader
implements ContentResourceReader {
    private final Resource filename;
    private final Optional<Charset> charset;

    protected abstract byte[] doReadFor(Optional<? extends Request> var1);

    protected AbstractFileResourceReader(Resource filename, Optional<Charset> charset) {
        this.charset = charset;
        this.filename = filename;
    }

    @Override
    public final MessageContent readFor(Optional<? extends Request> request) {
        return this.asMessageContent(this.doReadFor(request));
    }

    private MessageContent asMessageContent(byte[] content) {
        MessageContent.Builder builder = MessageContent.content().withContent(content);
        if (this.charset.isPresent()) {
            builder.withCharset((Charset)this.charset.get());
        }
        return builder.build();
    }

    @Override
    public final MediaType getContentType(HttpRequest request) {
        String targetFilename = this.filename((Optional<? extends Request>)Optional.of((Object)request));
        return new FileContentType(targetFilename, this.charset).getContentType();
    }

    protected final String filename(Optional<? extends Request> request) {
        MessageContent messageContent = this.filename.readFor(request);
        return messageContent.toString();
    }
}

