/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.reader.AbstractFileResourceReader;
import com.google.common.base.Optional;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class FileResourceReader
extends AbstractFileResourceReader {
    private final Optional<MocoConfig> config;

    public FileResourceReader(Resource file, Optional<Charset> charset) {
        this(file, charset, (Optional<MocoConfig>)Optional.absent());
    }

    public FileResourceReader(Resource file, Optional<Charset> charset, Optional<MocoConfig> config) {
        super(file, charset);
        this.config = config;
    }

    @Override
    protected byte[] doReadFor(Optional<? extends Request> request) {
        File file = new File(this.targetFileName(request));
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("%s does not exist", file.getPath()));
        }
        try {
            return Files.toByteArray((File)file);
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    private String targetFileName(Optional<? extends Request> request) {
        String filename = this.filename(request);
        if (this.config.isPresent()) {
            return ((MocoConfig)this.config.get()).apply(filename);
        }
        return filename;
    }
}

