/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.github.dreamhead.moco.resource.reader.TemplateRequest;
import com.github.dreamhead.moco.resource.reader.Variable;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateResourceReader
implements ContentResourceReader {
    private static final Version CURRENT_VERSION = Configuration.getVersion();
    private static final String TEMPLATE_NAME = "template";
    private static Logger logger = LoggerFactory.getLogger(TemplateResourceReader.class);
    private final ContentResource template;
    private final ImmutableMap<String, ? extends Variable> variables;

    public TemplateResourceReader(ContentResource template, ImmutableMap<String, ? extends Variable> variables) {
        this.template = template;
        this.variables = variables;
    }

    @Override
    public MessageContent readFor(Optional<? extends Request> request) {
        if (!request.isPresent()) {
            throw new IllegalStateException("Request is required to render template");
        }
        MessageContent content = this.template.readFor(request);
        try {
            Template targetTemplate = this.createTemplate(content);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            targetTemplate.process(this.variables((Request)request.get()), (Writer)writer);
            return MessageContent.content().withContent(stream.toByteArray()).build();
        }
        catch (ParseException e) {
            logger.error("Fail to parse template: {}", (Object)content.toString());
            throw new MocoException(e);
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
        catch (TemplateException e) {
            throw new MocoException(e);
        }
    }

    private Template createTemplate(MessageContent messageContent) throws IOException {
        StringTemplateLoader templateLoader = this.createTemplateLoader(messageContent);
        Configuration cfg = this.createConfiguration((TemplateLoader)templateLoader, messageContent.getCharset());
        return cfg.getTemplate(TEMPLATE_NAME);
    }

    private StringTemplateLoader createTemplateLoader(MessageContent messageContent) {
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate(TEMPLATE_NAME, messageContent.toString());
        return templateLoader;
    }

    private Configuration createConfiguration(TemplateLoader templateLoader, Charset charset) {
        Configuration cfg = new Configuration(CURRENT_VERSION);
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapperBuilder(CURRENT_VERSION).build());
        cfg.setDefaultEncoding(charset.name());
        cfg.setTemplateLoader(templateLoader);
        return cfg;
    }

    private ImmutableMap<String, Object> variables(Request request) {
        return ImmutableMap.builder().putAll(this.toVariableString(request)).put((Object)"req", (Object)this.toTemplateRequest(request)).build();
    }

    private TemplateRequest toTemplateRequest(Request request) {
        return new TemplateRequest(request);
    }

    private ImmutableMap<String, Object> toVariableString(final Request request) {
        return ImmutableMap.copyOf((Map)Maps.transformEntries(this.variables, (Maps.EntryTransformer)new Maps.EntryTransformer<String, Variable, Object>(){

            public Object transformEntry(String key, Variable value) {
                return value.toTemplateVariable(request);
            }
        }));
    }

    @Override
    public MediaType getContentType(HttpRequest request) {
        return this.template.getContentType(request);
    }

    static {
        System.setProperty("org.freemarker.loggerLibrary", "none");
    }
}

