/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.rest;

import com.github.dreamhead.moco.HttpMethod;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.RestIdMatcher;
import com.github.dreamhead.moco.RestSetting;
import com.github.dreamhead.moco.handler.JsonResponseHandler;
import com.github.dreamhead.moco.rest.CompositeRestSetting;
import com.github.dreamhead.moco.rest.RestAllSetting;
import com.github.dreamhead.moco.rest.RestIdMatchers;
import com.github.dreamhead.moco.rest.RestSingleSetting;
import com.github.dreamhead.moco.rest.SimpleRestSetting;
import com.github.dreamhead.moco.rest.SubResourceSetting;
import com.github.dreamhead.moco.util.URLs;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.netty.handler.codec.http.HttpResponseStatus;

public final class RestRequestDispatcher {
    private static final ResponseHandler NOT_FOUND_HANDLER = Moco.status(HttpResponseStatus.NOT_FOUND.code());
    private static final ResponseHandler BAD_REQUEST_HANDLER = Moco.status(HttpResponseStatus.BAD_REQUEST.code());
    private final RestIdMatcher name;
    private final RequestMatcher allMatcher;
    private final RequestMatcher singleMatcher;
    private final CompositeRestSetting<RestAllSetting> getAllSettings;
    private final CompositeRestSetting<RestSingleSetting> getSingleSettings;
    private final CompositeRestSetting<RestAllSetting> postSettings;
    private final CompositeRestSetting<RestSingleSetting> putSettings;
    private final CompositeRestSetting<RestSingleSetting> deleteSettings;
    private final CompositeRestSetting<RestSingleSetting> headSettings;
    private final CompositeRestSetting<RestAllSetting> headAllSettings;
    private final CompositeRestSetting<RestSingleSetting> patchSettings;
    private final FluentIterable<SubResourceSetting> subResourceSettings;

    public RestRequestDispatcher(String name, Iterable<RestSetting> settings) {
        this.name = RestIdMatchers.eq(name);
        this.getAllSettings = this.filterSettings(settings, RestAllSetting.class, HttpMethod.GET);
        this.getSingleSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.GET);
        this.postSettings = this.filterSettings(settings, RestAllSetting.class, HttpMethod.POST);
        this.putSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.PUT);
        this.deleteSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.DELETE);
        this.headSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.HEAD);
        this.headAllSettings = this.filterSettings(settings, RestAllSetting.class, HttpMethod.HEAD);
        this.patchSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.PATCH);
        this.subResourceSettings = this.filter(settings, SubResourceSetting.class);
        this.allMatcher = Moco.by(Moco.uri(URLs.resourceRoot(name)));
        this.singleMatcher = Moco.match(Moco.uri(URLs.join(URLs.resourceRoot(name), "[^/]*")));
    }

    private <T extends SimpleRestSetting> CompositeRestSetting<T> filterSettings(Iterable<RestSetting> settings, Class<T> type, HttpMethod method) {
        return new CompositeRestSetting<T>(this.filter(settings, type, method));
    }

    private <T> Function<? super T, T> toInstance(final Class<T> clazz) {
        return new Function<T, T>(){

            public T apply(T input) {
                return clazz.cast(input);
            }
        };
    }

    private <T extends SimpleRestSetting> FluentIterable<T> filter(Iterable<RestSetting> settings, Class<T> type, HttpMethod method) {
        return this.filter(settings, type).filter(this.isForMethod(method));
    }

    private <T extends RestSetting> FluentIterable<T> filter(Iterable<RestSetting> settings, Class<T> type) {
        return FluentIterable.from(settings).filter(type).transform(this.toInstance(type));
    }

    private <T extends SimpleRestSetting> Predicate<T> isForMethod(final HttpMethod method) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return ((SimpleRestSetting)input).isSimple() && ((SimpleRestSetting)input).isFor(method);
            }
        };
    }

    private Predicate<SimpleRestSetting> isJsonHandlers() {
        return new Predicate<SimpleRestSetting>(){

            public boolean apply(SimpleRestSetting setting) {
                return setting.getHandler() instanceof JsonResponseHandler;
            }
        };
    }

    private Function<SimpleRestSetting, JsonResponseHandler> toJsonHandler() {
        return new Function<SimpleRestSetting, JsonResponseHandler>(){

            public JsonResponseHandler apply(SimpleRestSetting setting) {
                return (JsonResponseHandler)JsonResponseHandler.class.cast(setting.getHandler());
            }
        };
    }

    private Function<JsonResponseHandler, Object> toPojo() {
        return new Function<JsonResponseHandler, Object>(){

            public Object apply(JsonResponseHandler handler) {
                return handler.getPojo();
            }
        };
    }

    private Optional<ResponseHandler> getSingleOrAllHandler(HttpRequest httpRequest, CompositeRestSetting<RestSingleSetting> single, CompositeRestSetting<RestAllSetting> all, RestIdMatcher name) {
        Optional<ResponseHandler> singleHandler = single.getMatched(name, httpRequest);
        if (singleHandler.isPresent()) {
            return singleHandler;
        }
        Optional<ResponseHandler> allHandler = all.getMatched(name, httpRequest);
        if (allHandler.isPresent()) {
            return allHandler;
        }
        return Optional.absent();
    }

    private Optional<ResponseHandler> getHeadHandler(HttpRequest httpRequest) {
        Optional<ResponseHandler> handler = this.getSingleOrAllHandler(httpRequest, this.headSettings, this.headAllSettings, this.name);
        if (handler.isPresent()) {
            return handler;
        }
        return Optional.of((Object)NOT_FOUND_HANDLER);
    }

    private Optional<ResponseHandler> getGetHandler(HttpRequest httpRequest) {
        FluentIterable settings;
        Optional<ResponseHandler> matchedSetting = this.getSingleOrAllHandler(httpRequest, this.getSingleSettings, this.getAllSettings, this.name);
        if (matchedSetting.isPresent()) {
            return matchedSetting;
        }
        if (this.allMatcher.match(httpRequest) && !(settings = FluentIterable.from(this.getSingleSettings.getSettings())).isEmpty() && settings.allMatch(this.isJsonHandlers())) {
            ImmutableList objects = settings.transform(this.toJsonHandler()).transform(this.toPojo()).toList();
            return Optional.of((Object)Moco.with(Moco.json(objects)));
        }
        return Optional.of((Object)NOT_FOUND_HANDLER);
    }

    private Optional<ResponseHandler> getPostHandler(HttpRequest request) {
        Optional<ResponseHandler> handler = this.postSettings.getMatched(this.name, request);
        if (handler.isPresent()) {
            return handler;
        }
        if (this.singleMatcher.match(request)) {
            return Optional.of((Object)NOT_FOUND_HANDLER);
        }
        return Optional.of((Object)BAD_REQUEST_HANDLER);
    }

    private Optional<ResponseHandler> getSingleResponseHandler(CompositeRestSetting<RestSingleSetting> settings, HttpRequest httpRequest) {
        Optional<ResponseHandler> handler = settings.getMatched(this.name, httpRequest);
        if (handler.isPresent()) {
            return handler;
        }
        return Optional.of((Object)NOT_FOUND_HANDLER);
    }

    public Optional<ResponseHandler> getResponseHandler(HttpRequest httpRequest) {
        if (this.allMatcher.match(httpRequest) || this.singleMatcher.match(httpRequest)) {
            return this.doGetResponseHandler(httpRequest);
        }
        return this.getSubResponseHandler(httpRequest);
    }

    private Optional<ResponseHandler> getSubResponseHandler(HttpRequest httpRequest) {
        for (SubResourceSetting subResourceSetting : this.subResourceSettings) {
            Optional<ResponseHandler> matched = subResourceSetting.getMatched(this.name, httpRequest);
            if (!matched.isPresent()) continue;
            return matched;
        }
        return Optional.absent();
    }

    private Optional<ResponseHandler> doGetResponseHandler(HttpRequest httpRequest) {
        HttpMethod method = httpRequest.getMethod();
        if (HttpMethod.GET == method) {
            return this.getGetHandler(httpRequest);
        }
        if (HttpMethod.POST == method) {
            return this.getPostHandler(httpRequest);
        }
        if (HttpMethod.PUT == method) {
            return this.getSingleResponseHandler(this.putSettings, httpRequest);
        }
        if (HttpMethod.DELETE == method) {
            return this.getSingleResponseHandler(this.deleteSettings, httpRequest);
        }
        if (HttpMethod.HEAD == method) {
            return this.getHeadHandler(httpRequest);
        }
        if (HttpMethod.PATCH == method) {
            return this.getSingleResponseHandler(this.patchSettings, httpRequest);
        }
        return Optional.absent();
    }
}

