/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.rest.builder;

import com.github.dreamhead.moco.HttpMethod;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseBase;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.RestIdMatcher;
import com.github.dreamhead.moco.RestSetting;
import com.github.dreamhead.moco.RestSettingBuilder;
import com.github.dreamhead.moco.handler.AndResponseHandler;
import com.github.dreamhead.moco.internal.AbstractResponseBase;
import com.github.dreamhead.moco.rest.RestAllSetting;
import com.github.dreamhead.moco.rest.RestSingleSetting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public abstract class RestSettingBuilders
extends AbstractResponseBase<RestSetting>
implements RestSettingBuilder,
ResponseBase<RestSetting> {
    private RequestMatcher matcher;

    protected abstract RestSetting createSetting(Optional<RequestMatcher> var1, ResponseHandler var2);

    @Override
    public ResponseBase<RestSetting> request(RequestMatcher matcher) {
        this.matcher = (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Request matcher should not be null");
        return this;
    }

    @Override
    public RestSetting response(ResponseHandler handler, ResponseHandler ... handlers) {
        return this.createSetting((Optional<RequestMatcher>)Optional.fromNullable((Object)this.matcher), AndResponseHandler.and((ResponseHandler)Preconditions.checkNotNull((Object)handler, (Object)"Response handler should not be null"), (ResponseHandler[])Preconditions.checkNotNull((Object)handlers, (Object)"Response handlers should not be null")));
    }

    public static RestSettingBuilder single(final HttpMethod method, final RestIdMatcher id) {
        return new RestSettingBuilders(){

            @Override
            protected RestSetting createSetting(Optional<RequestMatcher> matcher, ResponseHandler handler) {
                return new RestSingleSetting(method, id, matcher, handler);
            }
        };
    }

    public static RestSettingBuilder all(final HttpMethod method) {
        return new RestSettingBuilders(){

            @Override
            protected RestSetting createSetting(Optional<RequestMatcher> matcher, ResponseHandler handler) {
                return new RestAllSetting(method, matcher, handler);
            }
        };
    }
}

