/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;

public final class FileContentType {
    public static final MediaType DEFAULT_CONTENT_TYPE_WITH_CHARSET = MediaType.PLAIN_TEXT_UTF_8;
    private static final ImmutableMap<String, MediaType> CONTENT_TYPES = ImmutableMap.builder().put((Object)"png", (Object)MediaType.PNG).put((Object)"gif", (Object)MediaType.GIF).put((Object)"jpg", (Object)MediaType.JPEG).put((Object)"jpeg", (Object)MediaType.JPEG).put((Object)"tiff", (Object)MediaType.TIFF).put((Object)"css", (Object)MediaType.create((String)"text", (String)"css")).put((Object)"html", (Object)MediaType.create((String)"text", (String)"html")).put((Object)"txt", (Object)MediaType.create((String)"text", (String)"plain")).put((Object)"js", (Object)MediaType.create((String)"application", (String)"javascript")).put((Object)"json", (Object)MediaType.create((String)"application", (String)"json")).put((Object)"pdf", (Object)MediaType.PDF).put((Object)"zip", (Object)MediaType.ZIP).put((Object)"tar", (Object)MediaType.TAR).put((Object)"gz", (Object)MediaType.GZIP).put((Object)"xml", (Object)MediaType.create((String)"text", (String)"xml")).build();
    private final String filename;
    private final Optional<Charset> charset;

    public FileContentType(String filename) {
        this(filename, (Optional<Charset>)Optional.absent());
    }

    public FileContentType(String filename, Optional<Charset> charset) {
        this.filename = filename;
        this.charset = charset;
    }

    public MediaType getContentType() {
        Optional<MediaType> optionalType = this.toContentType(Files.getFileExtension((String)this.filename));
        Optional<Charset> targetCharset = this.toCharset(optionalType);
        MediaType type = (MediaType)optionalType.or((Object)DEFAULT_CONTENT_TYPE_WITH_CHARSET);
        if (targetCharset.isPresent() && !type.charset().equals(targetCharset)) {
            return type.withCharset((Charset)targetCharset.get());
        }
        return type;
    }

    private Optional<Charset> toCharset(Optional<MediaType> type) {
        if (this.charset.isPresent()) {
            return this.charset;
        }
        if (!type.isPresent()) {
            return Optional.of((Object)Charsets.UTF_8);
        }
        return ((MediaType)type.get()).charset();
    }

    private Optional<MediaType> toContentType(String extension) {
        return Optional.fromNullable((Object)CONTENT_TYPES.get((Object)extension.toLowerCase()));
    }
}

