/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.dreamhead.moco.MocoException;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jsons {
    private static Logger logger = LoggerFactory.getLogger(Jsons.class);
    private static final TypeFactory factory = TypeFactory.defaultInstance();
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toJson(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new MocoException(e);
        }
    }

    public static <T> T toObject(InputStream value, Class<T> clazz) {
        try {
            return (T)mapper.readValue(value, clazz);
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    public static <T> T toObject(String value, Class<T> clazz) {
        try {
            return (T)mapper.readValue(value, clazz);
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    public static <T> ImmutableList<T> toObjects(String value, Class<T> elementClass) {
        return Jsons.toObjects(new ByteArrayInputStream(value.getBytes()), elementClass);
    }

    public static <T> ImmutableList<T> toObjects(InputStream stream, Class<T> elementClass) {
        return Jsons.toObjects((ImmutableList<InputStream>)ImmutableList.of((Object)stream), elementClass);
    }

    public static <T> ImmutableList<T> toObjects(ImmutableList<InputStream> streams, Class<T> elementClass) {
        CollectionType type = factory.constructCollectionType(List.class, elementClass);
        return FluentIterable.from(streams).transformAndConcat(Jsons.toObject(type)).toList();
    }

    private static <T> Function<InputStream, Iterable<T>> toObject(final CollectionType type) {
        return new Function<InputStream, Iterable<T>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Iterable<T> apply(InputStream input) {
                try (InputStream actual = input;){
                    Iterable iterable = (Iterable)mapper.readValue(actual, (JavaType)type);
                    return iterable;
                }
                catch (UnrecognizedPropertyException e) {
                    logger.info("Unrecognized field: {}", (Object)e.getMessage());
                    throw new MocoException(String.format("Unrecognized field [ %s ], please check!", e.getPropertyName()));
                }
                catch (JsonMappingException e) {
                    logger.info("{} {}", (Object)e.getMessage(), (Object)e.getPathReference());
                    throw new MocoException(e);
                }
                catch (IOException e) {
                    throw new MocoException(e);
                }
            }
        };
    }

    private Jsons() {
    }
}

