/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;
import org.jbarcode.paint.BarcodePainter;
import org.jbarcode.paint.TextPainter;

public class JBarcode {
    public static final double MIN_XDIMENSION = 0.264583333;
    private int barHeight;
    private double wideToNarrow;
    private int xdimension;
    private boolean showText;
    private boolean checkDigit;
    private boolean showCheckDigit;
    private BarcodeEncoder bcencoder;
    private BarcodePainter bcpainter;
    private TextPainter textpainter;
    private double module;

    public JBarcode(BarcodeEncoder barcodeEncoder, BarcodePainter barcodePainter, TextPainter textPainter, double d, int n, double d2) {
        this.bcencoder = barcodeEncoder;
        this.bcpainter = barcodePainter;
        this.textpainter = textPainter;
        this.barHeight = n;
        this.xdimension = (int)(d / 0.264583333);
        this.xdimension = this.xdimension > 0 ? this.xdimension : 1;
        this.module = d;
        this.wideToNarrow = d2;
        this.showCheckDigit = true;
        this.checkDigit = true;
        this.showText = true;
    }

    public JBarcode(BarcodeEncoder barcodeEncoder, BarcodePainter barcodePainter, TextPainter textPainter) {
        this(barcodeEncoder, barcodePainter, textPainter, 0.264583333, 60, 2.0);
    }

    public BufferedImage createBarcode(String string) throws InvalidAtributeException {
        String string2 = new String(string);
        if (this.isCheckDigit()) {
            string = string + this.bcencoder.computeCheckSum(string);
            if (this.isShowCheckDigit()) {
                string2 = string;
            }
        }
        BarSet[] barSetArray = this.bcencoder.encode(string);
        BufferedImage bufferedImage = this.bcpainter.paint(barSetArray, 1, this.barHeight, this.wideToNarrow);
        if (this.isShowText()) {
            this.textpainter.paintText(bufferedImage, string2, 1);
        }
        BufferedImage bufferedImage2 = new BufferedImage((int)((double)bufferedImage.getWidth() * (this.module / 0.264583333)) + 1, (int)this.getBarHeight(), 1);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.module / 0.264583333, this.getBarHeight() / (double)bufferedImage.getHeight());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    public String calcCheckSum(String string) throws InvalidAtributeException {
        return this.bcencoder.computeCheckSum(string);
    }

    public double getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(double d) {
        this.barHeight = (int)Math.round(d / 0.264583333);
    }

    public BarcodeEncoder getEncoder() {
        return this.bcencoder;
    }

    public void setEncoder(BarcodeEncoder barcodeEncoder) {
        this.bcencoder = barcodeEncoder;
    }

    public BarcodePainter getPainter() {
        return this.bcpainter;
    }

    public void setPainter(BarcodePainter barcodePainter) {
        this.bcpainter = barcodePainter;
    }

    public double getWideRatio() {
        return this.wideToNarrow;
    }

    public void setWideRatio(double d) throws InvalidAtributeException {
        if (d < 1.0) {
            throw new InvalidAtributeException("[JBarcode] Invalid wide to narrow ratio value.");
        }
        this.wideToNarrow = d;
    }

    public double getXDimension() {
        return this.module;
    }

    public void setXDimension(double d) throws InvalidAtributeException {
        if (d < 0.0) {
            throw new InvalidAtributeException("[JBarcode] Invalid x-dimention value.");
        }
        this.xdimension = (int)(d / 0.264583333);
        this.xdimension = this.xdimension > 0 ? this.xdimension : 1;
        this.module = d;
    }

    public boolean isCheckDigit() {
        return this.checkDigit;
    }

    public void setCheckDigit(boolean bl) {
        this.checkDigit = bl;
    }

    public boolean isShowCheckDigit() {
        return this.showCheckDigit;
    }

    public void setShowCheckDigit(boolean bl) {
        this.showCheckDigit = bl;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean bl) {
        this.showText = bl;
    }

    public TextPainter getTextPainter() {
        return this.textpainter;
    }

    public void setTextPainter(TextPainter textPainter) {
        this.textpainter = textPainter;
    }

    public String toString() {
        return this.bcencoder.toString();
    }
}

