/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.InvalidAtributeException;
import org.jbarcode.encode.Standard2of5Encoder;

public class Interleaved2of5Encoder
extends Standard2of5Encoder {
    private BarSet START_CHAR = new BarSet("0000");
    private BarSet STOP_CHAR = new BarSet("100");
    private static Interleaved2of5Encoder instance;

    private Interleaved2of5Encoder() {
    }

    public static Standard2of5Encoder getInstance() {
        if (instance == null) {
            instance = new Interleaved2of5Encoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() < 1) {
            throw new InvalidAtributeException("[Interleaved2of5] Invalid text length (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[string.length() / 2 + 2];
        try {
            barSetArray[0] = this.START_CHAR;
            for (int i = 0; i < string.length() / 2; ++i) {
                int n = Interleaved2of5Encoder.charToInt(string.charAt(2 * i));
                int n2 = Interleaved2of5Encoder.charToInt(string.charAt(2 * i + 1));
                barSetArray[i + 1] = new BarSet(10);
                for (int j = 0; j < this.CODES_WIDTH[n].length(); ++j) {
                    barSetArray[i + 1].set(j * 2, this.CODES_WIDTH[n].get(j));
                    barSetArray[i + 1].set(j * 2 + 1, this.CODES_WIDTH[n2].get(j));
                }
            }
            barSetArray[barSetArray.length - 1] = this.STOP_CHAR;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidAtributeException("[Interleaved2of5] Only numbers suported.");
        }
        return barSetArray;
    }

    public String toString() {
        return "Interleaved 2of5";
    }
}

