/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.util;

import com.keypoint.PngEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.jmge.gif.Gif89Encoder;

public class ImageUtil {
    public static final String JPEG = "jpeg";
    public static final String PNG = "png";
    public static final String GIF = "gif";
    public static final int DEFAULT_DPI = 96;

    public static byte[] encode(BufferedImage bufferedImage, String string) throws IOException {
        return ImageUtil.encode(bufferedImage, string, 96, 96);
    }

    public static byte[] encode(BufferedImage bufferedImage, String string, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageUtil.encodeAndWrite(bufferedImage, string, byteArrayOutputStream, n, n2);
        return byteArrayOutputStream.toByteArray();
    }

    public static void encodeAndWrite(BufferedImage bufferedImage, String string, OutputStream outputStream) throws IOException {
        ImageUtil.encodeAndWrite(bufferedImage, string, outputStream, 96, 96);
    }

    public static void encodeAndWrite(BufferedImage bufferedImage, String string, OutputStream outputStream, int n, int n2) throws IOException {
        if (PNG.equals(string)) {
            PngEncoder pngEncoder = new PngEncoder(bufferedImage);
            pngEncoder.setDpi(n, n2);
            outputStream.write(pngEncoder.pngEncode());
        } else if (JPEG.equals(string)) {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        } else if (GIF.equals(string)) {
            Gif89Encoder gif89Encoder = new Gif89Encoder();
            gif89Encoder.addFrame(bufferedImage);
            gif89Encoder.setComments("JBarcode (http://jbarcode.ronisons.com)");
            gif89Encoder.encode(outputStream);
        } else {
            throw new IOException("Unsupported image type");
        }
    }
}

